/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.mail.smime.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.shaded.cms.CMSAlgorithm;
import org.bouncycastle.shaded.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.shaded.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.bouncycastle.shaded.mail.smime.SMIMEEnvelopedGenerator;

public class CreateEncryptedMail {
    public static void main(String[] stringArray) throws Exception {
        Certificate[] certificateArray;
        if (stringArray.length != 2) {
            System.err.println("usage: CreateEncryptedMail pkcs12Keystore password");
            System.exit(0);
        }
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
        keyStore.load(new FileInputStream(stringArray[0]), stringArray[1].toCharArray());
        Enumeration<String> enumeration = keyStore.aliases();
        Certificate[] certificateArray2 = null;
        while (enumeration.hasMoreElements()) {
            certificateArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)certificateArray)) continue;
            certificateArray2 = certificateArray;
        }
        if (certificateArray2 == null) {
            System.err.println("can't find a private key!");
            System.exit(0);
        }
        certificateArray = keyStore.getCertificateChain((String)certificateArray2);
        SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
        sMIMEEnvelopedGenerator.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator((X509Certificate)certificateArray[0]).setProvider("BC"));
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("Hello world!");
        MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC).setProvider("BC").build());
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        InternetAddress internetAddress = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress internetAddress2 = new InternetAddress("example@bouncycastle.org");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)internetAddress);
        mimeMessage.setRecipient(Message.RecipientType.TO, (Address)internetAddress2);
        mimeMessage.setSubject("example encrypted message");
        mimeMessage.setContent(mimeBodyPart2.getContent(), mimeBodyPart2.getContentType());
        mimeMessage.saveChanges();
        mimeMessage.writeTo((OutputStream)new FileOutputStream("encrypted.message"));
    }
}

