/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.mail.smime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.Recipient;
import org.bouncycastle.shaded.cms.RecipientId;
import org.bouncycastle.shaded.cms.RecipientInfoGenerator;
import org.bouncycastle.shaded.cms.RecipientInformation;
import org.bouncycastle.shaded.cms.RecipientInformationStore;
import org.bouncycastle.shaded.cms.SignerId;
import org.bouncycastle.shaded.cms.SignerInfoGenerator;
import org.bouncycastle.shaded.cms.SignerInformation;
import org.bouncycastle.shaded.cms.SignerInformationVerifier;
import org.bouncycastle.shaded.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.shaded.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.shaded.mail.smime.SMIMEException;
import org.bouncycastle.shaded.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.shaded.mail.smime.SMIMESignedParser;
import org.bouncycastle.shaded.mail.smime.SMIMEUtil;
import org.bouncycastle.shaded.operator.DigestCalculatorProvider;
import org.bouncycastle.shaded.operator.OutputEncryptor;
import org.bouncycastle.shaded.util.CollectionStore;

public class SMIMEToolkit {
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMIMEToolkit(DigestCalculatorProvider digestCalculatorProvider) {
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public boolean isEncrypted(Part part) throws MessagingException {
        return part.getHeader("Content-Type")[0].equals("application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data");
    }

    public boolean isSigned(Part part) throws MessagingException {
        return part.getHeader("Content-Type")[0].startsWith("multipart/signed") || part.getHeader("Content-Type")[0].equals("application/pkcs7-mime; name=smime.p7m; smime-type=signed-data");
    }

    public boolean isSigned(MimeMultipart mimeMultipart) throws MessagingException {
        return mimeMultipart.getBodyPart(1).getHeader("Content-Type")[0].equals("application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
    }

    public boolean isValidSignature(Part part, SignerInformationVerifier signerInformationVerifier) throws SMIMEException, MessagingException {
        try {
            SMIMESignedParser sMIMESignedParser = part.isMimeType("multipart/signed") ? new SMIMESignedParser(this.digestCalculatorProvider, (MimeMultipart)part.getContent()) : new SMIMESignedParser(this.digestCalculatorProvider, part);
            return this.isAtLeastOneValidSigner(sMIMESignedParser, signerInformationVerifier);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("CMS processing failure: " + cMSException.getMessage(), cMSException);
        }
        catch (IOException iOException) {
            throw new SMIMEException("Parsing failure: " + iOException.getMessage(), iOException);
        }
    }

    private boolean isAtLeastOneValidSigner(SMIMESignedParser sMIMESignedParser, SignerInformationVerifier signerInformationVerifier) throws CMSException {
        Object object;
        Object object2;
        if (signerInformationVerifier.hasAssociatedCertificate()) {
            object2 = signerInformationVerifier.getAssociatedCertificate();
            object = sMIMESignedParser.getSignerInfos().get(new SignerId(((X509CertificateHolder)object2).getIssuer(), ((X509CertificateHolder)object2).getSerialNumber()));
            if (object != null) {
                return ((SignerInformation)object).verify(signerInformationVerifier);
            }
        }
        object2 = sMIMESignedParser.getSignerInfos().getSigners();
        object = object2.iterator();
        while (object.hasNext()) {
            SignerInformation signerInformation = (SignerInformation)object.next();
            if (!signerInformation.verify(signerInformationVerifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSignature(MimeMultipart mimeMultipart, SignerInformationVerifier signerInformationVerifier) throws SMIMEException, MessagingException {
        try {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser(this.digestCalculatorProvider, mimeMultipart);
            return this.isAtLeastOneValidSigner(sMIMESignedParser, signerInformationVerifier);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("CMS processing failure: " + cMSException.getMessage(), cMSException);
        }
    }

    public X509CertificateHolder extractCertificate(Part part, SignerInformation signerInformation) throws SMIMEException, MessagingException {
        try {
            SMIMESignedParser sMIMESignedParser = part instanceof MimeMessage && part.isMimeType("multipart/signed") ? new SMIMESignedParser(this.digestCalculatorProvider, (MimeMultipart)part.getContent()) : new SMIMESignedParser(this.digestCalculatorProvider, part);
            Collection collection = sMIMESignedParser.getCertificates().getMatches(signerInformation.getSID());
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                return (X509CertificateHolder)iterator.next();
            }
            return null;
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("CMS processing failure: " + cMSException.getMessage(), cMSException);
        }
        catch (IOException iOException) {
            throw new SMIMEException("Parsing failure: " + iOException.getMessage(), iOException);
        }
    }

    public X509CertificateHolder extractCertificate(MimeMultipart mimeMultipart, SignerInformation signerInformation) throws SMIMEException, MessagingException {
        try {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser(this.digestCalculatorProvider, mimeMultipart);
            Collection collection = sMIMESignedParser.getCertificates().getMatches(signerInformation.getSID());
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                return (X509CertificateHolder)iterator.next();
            }
            return null;
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("CMS processing failure: " + cMSException.getMessage(), cMSException);
        }
    }

    public MimeMultipart sign(MimeBodyPart mimeBodyPart, SignerInfoGenerator signerInfoGenerator) throws SMIMEException {
        SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
        if (signerInfoGenerator.hasAssociatedCertificate()) {
            ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>();
            arrayList.add(signerInfoGenerator.getAssociatedCertificate());
            sMIMESignedGenerator.addCertificates(new CollectionStore(arrayList));
        }
        sMIMESignedGenerator.addSignerInfoGenerator(signerInfoGenerator);
        return sMIMESignedGenerator.generate(mimeBodyPart);
    }

    public MimeBodyPart signEncapsulated(MimeBodyPart mimeBodyPart, SignerInfoGenerator signerInfoGenerator) throws SMIMEException {
        SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
        if (signerInfoGenerator.hasAssociatedCertificate()) {
            ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>();
            arrayList.add(signerInfoGenerator.getAssociatedCertificate());
            sMIMESignedGenerator.addCertificates(new CollectionStore(arrayList));
        }
        sMIMESignedGenerator.addSignerInfoGenerator(signerInfoGenerator);
        return sMIMESignedGenerator.generateEncapsulated(mimeBodyPart);
    }

    public MimeBodyPart encrypt(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor, RecipientInfoGenerator recipientInfoGenerator) throws SMIMEException {
        SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
        sMIMEEnvelopedGenerator.addRecipientInfoGenerator(recipientInfoGenerator);
        return sMIMEEnvelopedGenerator.generate(mimeBodyPart, outputEncryptor);
    }

    public MimeBodyPart encrypt(MimeMultipart mimeMultipart, OutputEncryptor outputEncryptor, RecipientInfoGenerator recipientInfoGenerator) throws SMIMEException, MessagingException {
        SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
        sMIMEEnvelopedGenerator.addRecipientInfoGenerator(recipientInfoGenerator);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Multipart)mimeMultipart);
        return sMIMEEnvelopedGenerator.generate(mimeBodyPart, outputEncryptor);
    }

    public MimeBodyPart encrypt(MimeMessage mimeMessage, OutputEncryptor outputEncryptor, RecipientInfoGenerator recipientInfoGenerator) throws SMIMEException {
        SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
        sMIMEEnvelopedGenerator.addRecipientInfoGenerator(recipientInfoGenerator);
        return sMIMEEnvelopedGenerator.generate(mimeMessage, outputEncryptor);
    }

    public MimeBodyPart decrypt(MimeBodyPart mimeBodyPart, RecipientId recipientId, Recipient recipient) throws SMIMEException, MessagingException {
        try {
            SMIMEEnvelopedParser sMIMEEnvelopedParser = new SMIMEEnvelopedParser(mimeBodyPart);
            RecipientInformationStore recipientInformationStore = sMIMEEnvelopedParser.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            if (recipientInformation == null) {
                return null;
            }
            return SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(recipient));
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("CMS processing failure: " + cMSException.getMessage(), cMSException);
        }
        catch (IOException iOException) {
            throw new SMIMEException("Parsing failure: " + iOException.getMessage(), iOException);
        }
    }

    public MimeBodyPart decrypt(MimeMessage mimeMessage, RecipientId recipientId, Recipient recipient) throws SMIMEException, MessagingException {
        try {
            SMIMEEnvelopedParser sMIMEEnvelopedParser = new SMIMEEnvelopedParser(mimeMessage);
            RecipientInformationStore recipientInformationStore = sMIMEEnvelopedParser.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            if (recipientInformation == null) {
                return null;
            }
            return SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(recipient));
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("CMS processing failure: " + cMSException.getMessage(), cMSException);
        }
        catch (IOException iOException) {
            throw new SMIMEException("Parsing failure: " + iOException.getMessage(), iOException);
        }
    }
}

