/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.mule.connectivity.CommandCreateConnector;
import org.mule.connectivity.CommandCreateDescriptor;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.DescriptorMode;
import org.mule.connectivity.restconnect.api.DescriptorScaffolder;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.RestConnect;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;

public class Main {
    private static final String CREATE_DESCRIPTOR_COMMAND = "create-descriptor";
    private static final String CREATE_CONNECTOR_COMMAND = "create-connector";
    @Parameter(names={"-help"}, help=true)
    boolean help = false;

    public static void main(String ... argv) throws IOException, ModelGenerationException, TemplatingException {
        Main main = new Main();
        CommandCreateDescriptor createDescriptor = new CommandCreateDescriptor();
        CommandCreateConnector createConnector = new CommandCreateConnector();
        JCommander jCommander = JCommander.newBuilder().programName("Rest Connect CLI").addObject((Object)main).addCommand(CREATE_DESCRIPTOR_COMMAND, (Object)createDescriptor, new String[0]).addCommand(CREATE_CONNECTOR_COMMAND, (Object)createConnector, new String[0]).build();
        jCommander.parse(argv);
        String command = jCommander.getParsedCommand();
        if (main.help) {
            jCommander.usage();
            return;
        }
        if (CREATE_DESCRIPTOR_COMMAND.equals(command)) {
            Main.createDescriptor(createDescriptor);
        } else if (CREATE_CONNECTOR_COMMAND.equals(command)) {
            Main.createConnector(createConnector);
        } else {
            jCommander.usage();
        }
    }

    private static void createConnector(CommandCreateConnector createConnector) throws IOException, ModelGenerationException, TemplatingException {
        ConnectorModel connectorModel = RestConnect.getConnectorModel((File)createConnector.getApiDesc(), (File)createConnector.getApiSpec(), (SpecFormat)createConnector.getSpecFormat(), (Parser)createConnector.getParser(), (String)createConnector.getApiSpec().getParent(), (boolean)createConnector.getSkipValidation());
        RestConnect.generateConnector((ConnectorModel)connectorModel, (ConnectorType)ConnectorType.SDK_CONNECTOR, (Path)createConnector.getOutputDir(), (Path)createConnector.getApiDesc().toPath());
    }

    private static void createDescriptor(CommandCreateDescriptor createDescriptor) throws IOException, ModelGenerationException {
        DescriptorScaffolder.scaffoldDescriptor((File)createDescriptor.getApiSpec(), (SpecFormat)createDescriptor.getSpecFormat(), (Parser)createDescriptor.getParser(), (Path)createDescriptor.getOutputDir(), (DescriptorMode)createDescriptor.getMode(), (boolean)createDescriptor.getSkipValidation());
    }
}

