/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;

public abstract class AbstractRestConnectCommand {
    @Parameter(names={"-apiSpec"}, description="Api Specification", required=true, converter=FileConverter.class)
    private File apiSpec;
    @Parameter(names={"-outputDir"})
    private String outputDir;
    @Parameter(names={"-specFormat"}, description="API Specification format -- Possible values: RAML, JsonOAS, YamlOAS")
    private String specFormat;
    @Parameter(names={"-parser"}, description="Parser -- Possible values: RamlParser, AMF")
    private String parser;
    @Parameter(names={"-skipValidation"}, description="Skip Validation -- Possible values: true, false")
    private String skipValidation;

    public File getApiSpec() {
        return this.apiSpec;
    }

    public Path getOutputDir() throws IOException {
        Path output = StringUtils.isNotBlank((CharSequence)this.outputDir) ? (Files.exists(Paths.get(this.outputDir, new String[0]), new LinkOption[0]) ? Paths.get(this.outputDir, new String[0]) : Files.createDirectory(Paths.get(this.outputDir, new String[0]), new FileAttribute[0])) : Paths.get(".", new String[0]).toAbsolutePath().normalize();
        return output;
    }

    public SpecFormat getSpecFormat() {
        if (StringUtils.isBlank((CharSequence)this.specFormat)) {
            return SpecFormat.RAML;
        }
        return SpecFormat.getFromString((String)this.specFormat);
    }

    public Parser getParser() {
        if (StringUtils.isBlank((CharSequence)this.parser)) {
            return Parser.AMF;
        }
        return Parser.getFromString((String)this.parser);
    }

    public boolean getSkipValidation() {
        if (StringUtils.isBlank((CharSequence)this.skipValidation)) {
            return Boolean.parseBoolean(this.skipValidation);
        }
        return false;
    }
}

