/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity;

import static org.apache.commons.lang3.StringUtils.isBlank;
import org.mule.connectivity.restconnect.api.DescriptorMode;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

@Parameters(commandDescription = "Create the descriptor")
public class CommandCreateDescriptor extends AbstractRestConnectCommand {

  @Parameter(names = "-mode", description = "Mode -- Possible values: MINIMAL, VERBOSE")
  private String mode;

  public DescriptorMode getMode() {
    if (isBlank(mode)) {
      return DescriptorMode.MINIMAL;
    }
    return DescriptorMode.valueOf(mode);
  }
}
