/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity;

import static org.mule.connectivity.restconnect.api.ConnectorType.SDK_CONNECTOR;
import static org.mule.connectivity.restconnect.api.DescriptorScaffolder.scaffoldDescriptor;
import static org.mule.connectivity.restconnect.api.RestConnect.generateConnector;
import static org.mule.connectivity.restconnect.api.RestConnect.getConnectorModel;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;

import java.io.IOException;

public class Main {

  private static final String CREATE_DESCRIPTOR_COMMAND = "create-descriptor";
  private static final String CREATE_CONNECTOR_COMMAND = "create-connector";

  @Parameter(names = "-help", help = true)
  boolean help = false;

  public static void main(String... argv) throws IOException, ModelGenerationException, TemplatingException {
    Main main = new Main();
    CommandCreateDescriptor createDescriptor = new CommandCreateDescriptor();
    CommandCreateConnector createConnector = new CommandCreateConnector();
    JCommander jCommander = JCommander.newBuilder().programName("Rest Connect CLI")
        .addObject(main).addCommand(CREATE_DESCRIPTOR_COMMAND, createDescriptor)
        .addCommand(CREATE_CONNECTOR_COMMAND, createConnector)
        .build();
    jCommander.parse(argv);
    String command = jCommander.getParsedCommand();

    if (main.help) {
      jCommander.usage();
      return;
    }

    if (CREATE_DESCRIPTOR_COMMAND.equals(command)) {
      createDescriptor(createDescriptor);
    } else if (CREATE_CONNECTOR_COMMAND.equals(command)) {
      createConnector(createConnector);
    } else {
      jCommander.usage();
    }
  }

  private static void createConnector(CommandCreateConnector createConnector)
      throws IOException, ModelGenerationException, TemplatingException {

    ConnectorModel connectorModel = getConnectorModel(createConnector.getApiDesc(),
                                                      createConnector.getApiSpec(),
                                                      createConnector.getSpecFormat(),
                                                      createConnector.getParser(),
                                                      createConnector.getApiSpec().getParent(),
                                                      createConnector.getSkipValidation());

    generateConnector(connectorModel,
                      SDK_CONNECTOR,
                      createConnector.getOutputDir(),
                      createConnector.getApiDesc().toPath());
  }

  private static void createDescriptor(CommandCreateDescriptor createDescriptor) throws IOException, ModelGenerationException {

    scaffoldDescriptor(createDescriptor.getApiSpec(),
                       createDescriptor.getSpecFormat(),
                       createDescriptor.getParser(),
                       createDescriptor.getOutputDir(),
                       createDescriptor.getMode(),
                       createDescriptor.getSkipValidation());
  }

}
