/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12pre.extension.internal.schemas;

import com.mulesoft.connectors.x12pre.extension.internal.schemas.LoadingErrorException;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.SchemaCache;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.x12.X12Acknowledgment$;
import com.mulesoft.flatfile.schema.x12.X12FormConverter$;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class SchemaSet {
    private final java.util.Map<String, java.util.Map<String, Structure>> versionStructures = new ConcurrentHashMap<String, java.util.Map<String, Structure>>();
    private final Structure ackStructure;
    private final EdiForm ediForm;
    private final SchemaCache schemaCache;
    private final boolean loadOnDemand;

    private SchemaSet(boolean basex12, boolean gen999, EdiForm form, SchemaCache cache, boolean ondemand) {
        X12Acknowledgment$ module = X12Acknowledgment$.MODULE$;
        this.ackStructure = gen999 ? (basex12 ? module.trans999x12() : module.trans999hipaa()) : (basex12 ? module.trans997x12() : module.trans997hipaa());
        this.ediForm = form;
        this.schemaCache = cache;
        this.loadOnDemand = ondemand;
    }

    public SchemaSet(boolean basex12, boolean gen999, EdiForm form, SchemaCache cache) {
        this(basex12, gen999, form, cache, true);
    }

    public SchemaSet(boolean basex12, boolean gen999, EdiForm form, SchemaCache cache, List<String> paths) {
        this(basex12, gen999, form, cache, false);
        List<EdiSchema> schemas = cache.getSchemas(paths);
        for (int i = 0; i < paths.size(); ++i) {
            EdiSchema schema = schemas.get(i);
            if (schema.ediVersion().ediForm() != this.ediForm) {
                throw new LoadingErrorException("Schema [" + paths.get(i) + "] is of form " + schema.ediVersion().ediForm().text() + ", not the configured " + this.ediForm.text());
            }
            JavaConverters.mapAsJavaMap((Map)schema.structures()).forEach((ident, struct) -> {
                String version = struct.version().versionKey();
                java.util.Map vmap = this.versionStructures.computeIfAbsent(version, v -> new ConcurrentHashMap());
                if (vmap.put(ident, struct) != null) {
                    throw new LoadingErrorException("Multiple structure definitions found for structure " + ident + " at version " + version);
                }
            });
        }
    }

    public java.util.Map<String, java.util.Map<String, Structure>> getVersionStructures() {
        return this.versionStructures;
    }

    public Structure getAckStructure() {
        return this.ackStructure;
    }

    public Structure getStructureSchema(String version, String verpath, String setId) {
        Structure struct = null;
        java.util.Map<String, Structure> structDefs = this.versionStructures.get(version);
        if (structDefs != null) {
            struct = structDefs.get(setId);
        }
        if (struct == null && this.ackStructure.ident().equals(setId)) {
            struct = this.ackStructure;
        }
        if (struct == null && this.loadOnDemand) {
            YamlReader yamlrdr = new YamlReader((EdiFormConverter)X12FormConverter$.MODULE$);
            String path = SchemaCache.classpathSchemaPath(verpath, setId);
            EdiSchema schema = this.schemaCache.getSchema(path, yamlrdr);
            if (schema == null) {
                path = SchemaCache.fileSchemaPath(verpath, setId);
                schema = this.schemaCache.getSchema(path, yamlrdr);
            }
            if (schema != null) {
                Option option = schema.structures().get((Object)setId);
                if (option.isEmpty()) {
                    throw new IllegalArgumentException("Schema from path [" + path + "] for structure [" + setId + "] at version [" + version + "] does not define that structure");
                }
                struct = (Structure)option.get();
                java.util.Map vmap = this.versionStructures.computeIfAbsent(version, v -> new ConcurrentHashMap());
                vmap.put(setId, struct);
            }
        }
        return struct;
    }
}

