/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12pre.extension.internal.schemas;

import com.mulesoft.connectors.x12pre.extension.internal.schemas.LoadingErrorException;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.NotFoundException;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SchemaCache {
    private final String INCLUDE_IGNORED = "-INCLUDE";
    private Map<String, EdiSchema> loadedSchemas = new ConcurrentHashMap<String, EdiSchema>();

    private EdiSchema loadAndVerifySchema(String path, YamlReader yamlrdr) {
        EdiSchema schema;
        YamlReader.InputSource source;
        try {
            source = YamlReader$.MODULE$.findSchema(path);
        }
        catch (Throwable t) {
            return null;
        }
        try {
            InputStreamReader reader = new InputStreamReader(source.input());
            schema = yamlrdr.loadYaml((Reader)reader, source.prefixPaths(), false);
        }
        catch (Exception t) {
            throw new LoadingErrorException("Error loading schema from path " + path, t);
        }
        return schema;
    }

    public static String classpathSchemaPath(String version, String setId) {
        if (X12SchemaDefs.isHipaaVersion((String)version)) {
            return "/hipaa/" + version + "/" + setId + ".esl";
        }
        return "/x12/" + version + "/" + setId + ".esl";
    }

    public static String fileSchemaPath(String version, String setId) {
        if (X12SchemaDefs.isHipaaVersion((String)version)) {
            return "hipaa" + File.separator + version + File.separator + setId + ".esl";
        }
        return "x12" + File.separator + version + File.separator + setId + ".esl";
    }

    public EdiSchema getSchema(String path, YamlReader yamlrdr, boolean includeIgnored) {
        EdiSchema schema;
        String searchPath;
        String string = searchPath = includeIgnored ? path + "-INCLUDE" : path;
        if (!this.loadedSchemas.containsKey(searchPath) && (schema = this.loadAndVerifySchema(path, yamlrdr)) != null) {
            this.loadedSchemas.put(searchPath, schema);
        }
        return this.loadedSchemas.get(searchPath);
    }

    public List<EdiSchema> getSchemas(List<String> paths, YamlReader yamlrdr, boolean includeIgnored) {
        ArrayList<EdiSchema> schemas = new ArrayList<EdiSchema>();
        ArrayList<String> missings = new ArrayList<String>();
        for (String path : paths) {
            EdiSchema schema = this.getSchema(path, yamlrdr, includeIgnored);
            if (schema == null) {
                missings.add(path);
                continue;
            }
            schemas.add(schema);
        }
        if (!missings.isEmpty()) {
            throw new NotFoundException(missings);
        }
        return schemas;
    }
}

