/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12pre.extension.internal.metadata;

import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.x12.X12Acknowledgment;
import com.mulesoft.flatfile.schema.x12.X12Error;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.flatfile.metadata.schema.SegmentHandler;
import org.mule.flatfile.metadata.schema.StructureHandler;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.JavaTypeLoader;

public class ConnectorTypeLoader
implements TypeLoader {
    public static final MetadataFormat X12 = new MetadataFormat("X12", "x12", new String[]{"application/text"});
    public static final String INPUT_IDENTIFIER = "write";
    public static final String OUTPUT_IDENTIFIER = "read";
    private final Structure ackStructure;
    private final boolean addParserAck;
    private final Map<String, Map<String, Structure>> versionStructs;

    public ConnectorTypeLoader(Structure ack, boolean addAck, Map<String, Map<String, Structure>> verstructs) {
        this.ackStructure = ack;
        this.addParserAck = addAck;
        this.versionStructs = verstructs;
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    public Optional<MetadataType> load(String identifier, String typeAlias) {
        BaseTypeBuilder baseBuilder = new BaseTypeBuilder(X12);
        ObjectTypeBuilder root = baseBuilder.objectType();
        DefaultStringType delimType = baseBuilder.stringType().length(Integer.valueOf(4)).build();
        boolean readData = OUTPUT_IDENTIFIER.equals(identifier);
        root.addField().key(SchemaJavaValues.delimiterCharacters()).description("Delimiter characters").value((MetadataType)delimType).required(readData);
        EdiForm form = this.ackStructure.version().ediForm();
        StructureHandler structHandler = new StructureHandler(X12, form, Collections.emptyMap());
        ObjectFieldTypeBuilder dataField = root.addField();
        dataField.key(X12SchemaDefs.transactionsMap()).required().description("Transaction sets");
        ObjectTypeBuilder dataObject = dataField.value().objectType();
        Object[] vkeys = this.versionStructs.keySet().toArray(new String[0]);
        Arrays.sort(vkeys);
        for (Object vkey : vkeys) {
            ObjectFieldTypeBuilder versionField = dataObject.addField();
            versionField.key((String)vkey);
            ObjectTypeBuilder versionObject = versionField.value().objectType();
            Map<String, Structure> vmap = this.versionStructs.get(vkey);
            Object[] skeys = vmap.keySet().toArray(new String[0]);
            Arrays.sort(skeys);
            for (Object skey : skeys) {
                this.addStructure(vmap.get(skey), readData, versionObject, baseBuilder, structHandler);
            }
            if (!this.addParserAck || vmap.containsKey(this.ackStructure.ident()) || this.ackStructure.version().version().length() != 6) continue;
            this.addStructure(this.ackStructure, readData, versionObject, baseBuilder, structHandler);
        }
        SegmentHandler ta1Handler = new SegmentHandler(form, X12, Collections.emptyMap());
        if (readData) {
            this.addErrorList(root, "Parser errors and warnings (of all levels)", true);
            ObjectFieldTypeBuilder genAcksGenField = root.addField();
            genAcksGenField.key(SchemaJavaValues.functionalAcksGenerated()).description("Generated Functional Acknowledgments").required();
            ObjectTypeBuilder ackBuilder = baseBuilder.objectType();
            this.addISA(ackBuilder, "Received Interchange Header (ISA)", true, structHandler);
            this.addGS(ackBuilder, "Received Functional Group Header (GS)", true, structHandler);
            structHandler.buildStructure(this.ackStructure, readData, ackBuilder);
            genAcksGenField.value().arrayType().of((TypeBuilder)ackBuilder);
            Map types = TypeConverterFactory.buildTypeConverter((MetadataFormat)X12);
            ObjectTypeBuilder genTa1Builder = baseBuilder.objectType();
            ta1Handler.buildSegment(X12Acknowledgment.segTA1(), genTa1Builder);
            this.addISA(genTa1Builder, "Interchange Header (ISA)", true, structHandler);
            ObjectType genTa1Type = genTa1Builder.build();
            ObjectFieldTypeBuilder genTA1sGenField = root.addField();
            genTA1sGenField.key(SchemaJavaValues.interchangeAcksGenerated()).description("Generated TA1 Acknowledgments").required().value().arrayType().of((MetadataType)genTa1Type);
            genTa1Builder = baseBuilder.objectType();
            ta1Handler.buildSegment(X12Acknowledgment.segTA1(), genTa1Builder);
            ObjectFieldTypeBuilder genTA1sRcvField = root.addField();
            genTA1sRcvField.key(SchemaJavaValues.interchangeAcksReceived()).description("Received TA1 Acknowledgments").value().arrayType().of((TypeBuilder)genTa1Builder);
        } else {
            this.addISA(root, "Send Interchange Header (ISA) defaults", false, structHandler);
            this.addGS(root, "Functional Group Header (GS) defaults", false, structHandler);
            ObjectTypeBuilder genTa1Builder = baseBuilder.objectType();
            ta1Handler.buildSegment(X12Acknowledgment.segTA1(), genTa1Builder);
            ObjectFieldTypeBuilder genTA1sSendField = root.addField();
            genTA1sSendField.key(SchemaJavaValues.interchangeAcksToSend()).description("TA1 Acknowledgments to send").value().arrayType().of((TypeBuilder)genTa1Builder);
            structHandler.buildSegment(X12Acknowledgment.segTA1(), genTA1sSendField);
        }
        MetadataTypeUtils.addTypeAlias((TypeBuilder)root, (String)typeAlias);
        return Optional.of(root.build());
    }

    private void addStructure(Structure struct, boolean readData, ObjectTypeBuilder versionObject, BaseTypeBuilder baseBuilder, StructureHandler structHandler) {
        ObjectFieldTypeBuilder structField = versionObject.addField();
        structField.key(struct.ident()).description(struct.name());
        ObjectTypeBuilder builder = baseBuilder.objectType();
        if (readData) {
            this.addErrorList(builder, "Parser errors and warnings in transaction set", false);
        }
        this.addISA(builder, "Interchange Header (ISA)", readData, structHandler);
        this.addGS(builder, "Functional Group Header (GS)", readData, structHandler);
        ObjectFieldTypeBuilder stField = builder.addField();
        stField.key(X12SchemaDefs.setHeaderKey()).required(readData).description("Transaction Set Header (ST)");
        structHandler.buildSegment(X12SchemaDefs.STSegment(), stField);
        ObjectFieldTypeBuilder seField = builder.addField();
        seField.key(X12SchemaDefs.setTrailerKey()).required(readData).description("Transaction Set Trailer (ST)");
        structHandler.buildSegment(X12SchemaDefs.SESegment(), seField);
        ObjectFieldTypeBuilder ieaField = builder.addField();
        ieaField.key(X12SchemaDefs.interchangeTrailerKey()).required(false).description("Interchange Control Trailer (IEA)");
        structHandler.buildSegment(X12SchemaDefs.IEASegment(), ieaField);
        ObjectFieldTypeBuilder geField = builder.addField();
        geField.key(X12SchemaDefs.groupTrailerKey()).required(false).description("Functional Group Trailer (GE)");
        structHandler.buildSegment(X12SchemaDefs.GESegment(), geField);
        structField.value().arrayType().of(structHandler.buildStructure(struct, readData, builder));
    }

    private void addGS(ObjectTypeBuilder parent, String describe, boolean required, StructureHandler structHandler) {
        ObjectFieldTypeBuilder gsField = parent.addField();
        gsField.key(SchemaJavaValues.groupKey()).required(required).description(describe);
        structHandler.buildSegment(X12SchemaDefs.GSSegment(), gsField);
    }

    private void addISA(ObjectTypeBuilder parent, String describe, boolean required, StructureHandler structHandler) {
        ObjectFieldTypeBuilder isaField = parent.addField();
        isaField.key(SchemaJavaValues.interchangeKey()).required(required).description(describe);
        structHandler.buildSegment(X12SchemaDefs.ISASegment(), isaField);
    }

    private void addErrorList(ObjectTypeBuilder parent, String describe, boolean required) {
        ObjectFieldTypeBuilder errorsField = parent.addField();
        errorsField.key(SchemaJavaValues.errorListKey()).description(describe).required(required);
        ObjectTypeBuilder object = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        JavaTypeLoader loader = new JavaTypeLoader(this.getClass().getClassLoader());
        MetadataType javaType = loader.load(X12Error.class);
        errorsField.value().arrayType().of(javaType);
    }
}

