/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12pre.extension.internal.schemas;

import com.mulesoft.connectors.x12pre.extension.internal.schemas.LoadingErrorException;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.NotFoundException;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.x12.X12FormConverter$;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SchemaCache {
    private Map<String, EdiSchema> loadedSchemas = new ConcurrentHashMap<String, EdiSchema>();

    private EdiSchema loadAndVerifySchema(String path, YamlReader yamlrdr) {
        EdiSchema schema;
        YamlReader.InputSource source;
        try {
            source = YamlReader$.MODULE$.findSchema(path);
        }
        catch (Throwable t) {
            return null;
        }
        try {
            InputStreamReader reader = new InputStreamReader(source.input());
            schema = yamlrdr.loadYaml((Reader)reader, source.prefixPaths(), false);
        }
        catch (Exception t) {
            throw new LoadingErrorException("Error loading schema from path " + path, t);
        }
        return schema;
    }

    public static String classpathSchemaPath(String version, String setId) {
        return "/x12/" + version.toLowerCase() + "/" + setId.toUpperCase() + ".esl";
    }

    public static String fileSchemaPath(String version, String setId) {
        return "x12" + File.separator + version.toLowerCase() + File.separator + setId.toUpperCase() + ".esl";
    }

    public EdiSchema getSchema(String path, YamlReader yamlrdr) {
        EdiSchema schema;
        if (!this.loadedSchemas.containsKey(path) && (schema = this.loadAndVerifySchema(path, yamlrdr)) != null) {
            this.loadedSchemas.put(path, schema);
        }
        return this.loadedSchemas.get(path);
    }

    public List<EdiSchema> getSchemas(List<String> paths) {
        ArrayList<EdiSchema> schemas = new ArrayList<EdiSchema>();
        ArrayList<String> missings = new ArrayList<String>();
        YamlReader yamlrdr = new YamlReader((EdiFormConverter)X12FormConverter$.MODULE$);
        for (String path : paths) {
            EdiSchema schema = this.getSchema(path, yamlrdr);
            if (schema == null) {
                missings.add(path);
                continue;
            }
            schemas.add(schema);
        }
        if (!missings.isEmpty()) {
            throw new NotFoundException(missings);
        }
        return schemas;
    }
}

