/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12pre.extension.internal.schemas;

import com.mulesoft.connectors.x12pre.extension.internal.schemas.LoadingErrorException;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.NotFoundException;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.SchemaCache;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.EdiSchemaVersion$;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.x12.X12AckSchema;
import com.mulesoft.flatfile.schema.x12.X12AckSchema$;
import com.mulesoft.flatfile.schema.x12.X12FormConverter$;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Traversable;

public class SchemaSet {
    private final java.util.Map<String, java.util.Map<String, Structure>> versionStructures;
    private final java.util.Map<String, java.util.Map<String, Segment>> loadedEnvelopeSegments;
    private X12AckSchema ackSchema;
    private final EdiForm ediForm;
    private final SchemaCache schemaCache;
    private YamlReader yamlrdr = new YamlReader((EdiFormConverter)X12FormConverter$.MODULE$);
    private String path;

    public SchemaSet(boolean basex12, boolean gen999, EdiForm form, SchemaCache cache) {
        this.versionStructures = new ConcurrentHashMap<String, java.util.Map<String, Structure>>();
        this.loadedEnvelopeSegments = new ConcurrentHashMap<String, java.util.Map<String, Segment>>();
        this.ackSchema = new X12AckSchema(X12AckSchema$.MODULE$.acknowledgmentDef(null, gen999, EdiSchemaVersion$.MODULE$.apply(form)));
        this.ediForm = form;
        this.schemaCache = cache;
    }

    public SchemaSet(boolean basex12, boolean gen999, EdiForm form, SchemaCache cache, List<String> paths) {
        this(basex12, gen999, form, cache);
        List<EdiSchema> schemas = cache.getSchemas(paths);
        for (int i = 0; i < paths.size(); ++i) {
            EdiSchema schema = schemas.get(i);
            if (schema.ediVersion().ediForm() != this.ediForm) {
                throw new LoadingErrorException("Schema [" + paths.get(i) + "] is of form " + schema.ediVersion().ediForm().text() + ", not the configured " + this.ediForm.text());
            }
            this.loadEnvelopeSegments(schema);
            JavaConverters.mapAsJavaMap((Map)schema.structures()).forEach((ident, struct) -> {
                String version = struct.version().versionKey();
                java.util.Map vmap = this.versionStructures.computeIfAbsent(version, v -> new ConcurrentHashMap());
                if (vmap.put(ident, struct) != null) {
                    throw new LoadingErrorException("Multiple structure definitions found for structure " + ident + " at version " + version);
                }
            });
            if ((gen999 || !schema.structures().contains((Object)"997")) && (!gen999 || !schema.structures().contains((Object)"999"))) continue;
            this.ackSchema = new X12AckSchema(X12AckSchema$.MODULE$.acknowledgmentDef(Option.apply((Object)schema), gen999, schema.ediVersion()));
        }
    }

    public java.util.Map<String, java.util.Map<String, Structure>> getVersionStructures() {
        return this.versionStructures;
    }

    public Structure getAckStructure() {
        return this.ackSchema.acknowledgmentDef().structure();
    }

    public X12AckSchema getAckSchema() {
        return this.ackSchema;
    }

    public Structure getStructureSchema(String version, String verpath, String setId) {
        EdiSchema schema;
        Structure struct = null;
        java.util.Map<String, Structure> structDefs = this.versionStructures.get(version);
        if (structDefs != null) {
            struct = structDefs.get(setId);
        }
        if (struct == null && (schema = this.getEdiSchema(verpath, setId)) != null) {
            Option option = schema.structures().get((Object)setId);
            if (option.isEmpty()) {
                throw new IllegalArgumentException("Schema from path [" + this.path + "] for structure [" + setId + "] at version [" + version + "] does not define that structure");
            }
            struct = (Structure)option.get();
            java.util.Map vmap = this.versionStructures.computeIfAbsent(version, v -> new ConcurrentHashMap());
            vmap.put(setId, struct);
        }
        return struct;
    }

    private EdiSchema getEdiSchema(String versionNumber, String setId) {
        this.path = SchemaCache.classpathSchemaPath(versionNumber, setId);
        EdiSchema schema = this.schemaCache.getSchema(this.path, this.yamlrdr);
        if (schema == null) {
            this.path = SchemaCache.fileSchemaPath(versionNumber, setId);
            schema = this.schemaCache.getSchema(this.path, this.yamlrdr);
        }
        return schema;
    }

    private java.util.Map<String, Segment> loadEnvelopeSegments(EdiSchema schema) {
        String schemaVersion = schema.ediVersion().versionKey();
        java.util.Map<String, Segment> envelopeSegments = this.extractEnvelopeSegmentsFrom(schema);
        this.loadedEnvelopeSegments.putIfAbsent(schemaVersion, envelopeSegments);
        return envelopeSegments;
    }

    private java.util.Map<String, Segment> extractEnvelopeSegmentsFrom(EdiSchema schema) {
        HashMap<String, Segment> envelopeSegments = new HashMap<String, Segment>();
        ((Traversable)schema.segments().filter(s -> this.ediForm.isEnvelopeSegment(((Segment)s._2).tag()))).foreach(t -> envelopeSegments.put(((Segment)t._2).tag(), X12SchemaDefs.normalizeSegment((Segment)((Segment)t._2))));
        return envelopeSegments;
    }

    public java.util.Map<String, Segment> getEnvelopeSegmentsBy(String version, String setId) {
        if (this.loadedEnvelopeSegments.containsKey(version)) {
            return this.loadedEnvelopeSegments.get(version);
        }
        EdiSchema schema = this.getEdiSchema(version.substring(1), setId);
        if (schema == null) {
            throw new NotFoundException(String.format("The schema for this path '%s' couldn't be found.", this.path));
        }
        return this.loadEnvelopeSegments(schema);
    }
}

