/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.x12;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.formats.ExplicitDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.GeneralStringFormat;
import com.mulesoft.flatfile.lexical.formats.ImpliedDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.IntegerFormat;
import com.mulesoft.flatfile.lexical.formats.MillisecondTimeFormat;
import com.mulesoft.flatfile.lexical.formats.X12DateFormat;
import java.nio.charset.Charset;

public final class X12Constants {
    public static final Charset EBCDIC_CHARSET = Charset.forName("IBM1047");
    public static final String CHAR_SET = "Character set";
    public static final String AUTHORIZATION_QUALIFIER = "ISA01";
    public static final String AUTHORIZATION_INFO = "ISA02";
    public static final String SECURITY_QUALIFIER = "ISA03";
    public static final String SECURITY_INFO = "ISA04";
    public static final String SENDER_ID_QUALIFIER = "ISA05";
    public static final String SENDER_ID = "ISA06";
    public static final String RECEIVER_ID_QUALIFIER = "ISA07";
    public static final String RECEIVER_ID = "ISA08";
    public static final String INTERCHANGE_DATE = "ISA09";
    public static final String INTERCHANGE_TIME = "ISA10";
    public static final String REPETITION_SEPARATOR = "ISA11";
    public static final String VERSION_ID = "ISA12";
    public static final String INTER_CONTROL = "ISA13";
    public static final String ACK_REQUESTED = "ISA14";
    public static final String TEST_INDICATOR = "ISA15";
    public static final String COMPONENT_SEPARATOR = "ISA16";
    public static final String STANDARD_IDENTIFIER = "ISA11";
    public static final String FUNCTIONAL_IDENTIFIER = "GS01";
    public static final String APPLICATION_SENDER = "GS02";
    public static final String APPLICATION_RECEIVER = "GS03";
    public static final String GROUP_DATE = "GS04";
    public static final String GROUP_TIME = "GS05";
    public static final String GROUP_CONTROL_NUMBER = "GS06";
    public static final String RESPONSIBLE_AGENCY = "GS07";
    public static final String VERSION_RELEASE_INDUSTRY_IDENTIFIER = "GS09";
    public static final String ST_ID_CODE = "ST01";
    public static final String ST_CONTROL_NUMBER = "ST02";
    public static final String ST_IMPLEMENTATION_CONVENTION_REF = "ST03";
    public static final String TRANSACTION_SETS = "TransactionSets";
    public static final String INTERCHANGE = "Interchange";
    public static final String SET_HEADER = "SetHeader";
    public static final String GROUP = "Group";
    public static final String GROUPS = "Groups";
    public static final String SET_TRAILER = "SetTrailer";
    public static final String ENVELOPE_SEGMENTS_KEY = "EnvelopeSegments";
    public static final String TRANSACTION_SET_IDENTIFIER = "Transaction set identifier code";
    public static final String TRANSACTION_SET_CONTROL_NUMBER = "Transaction set control number";
    public static final String IMPLEMENTATION_CONVENTION_REFERENCE = "Implementation convention reference";
    public static final String HIERARCHICAL_LEVEL = "HL";
    public static final String TRANSACTION_SET_LINE_NUMBER = "LX";
    public static final String INTERCHANGE_CONTROL_HEADER = "ISA";
    public static final String FUNCTIONAL_GROUP_HEADER = "GS";
    public static final String TRANSACTION_SET_HEADER = "ST";
    public static final String TRANSACTION_SET_TRAILER = "SE";
    public static final String FUNCTIONAL_GROUP_TRAILER = "GE";
    public static final String INTERCHANGE_CONTROL_TRAILER = "IEA";
    private static final boolean[] basicCharacterSet = new boolean[128];
    private static final boolean[] extendedCharacterSet;
    public static final TypeFormat VALID1;
    public static final TypeFormat VALID1_2;
    public static final TypeFormat VALID2;
    public static final TypeFormat VALID3;
    public static final TypeFormat VALID5;
    public static final TypeFormat VALAN1;
    public static final TypeFormat VALAN1_12;
    public static final TypeFormat VALAN1_35;
    public static final TypeFormat VALAN2_15;
    public static final TypeFormat VALAN4_9;
    public static final TypeFormat VALAN10;
    public static final TypeFormat VALAN15;
    public static final TypeFormat VALDT6;
    public static final TypeFormat VALDT6_8;
    public static final TypeFormat VALTM4;
    public static final TypeFormat VALTM4_8;
    public static final TypeFormat VALN9;
    public static final TypeFormat VALN1_5;
    public static final TypeFormat VALN1_9;

    public static String typeName(String type, int minLength, int maxLength) {
        if (minLength == maxLength) {
            return type + '(' + maxLength + ')';
        }
        return type + '(' + minLength + '-' + maxLength + ')';
    }

    public static TypeFormat buildType(String type, int minLength, int maxLength) {
        String norm = type.toUpperCase();
        if ("AN".equals(norm)) {
            return new GeneralStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT);
        }
        if ("R".equals(norm)) {
            return new ExplicitDecimalFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.NEGATIVE_ONLY, false, TypeFormatConstants.FillMode.ZEROES, false, false, true, false);
        }
        if (norm.startsWith("N")) {
            char chr;
            if (norm.length() == 1 || "N0".equals(norm)) {
                return new IntegerFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.NEGATIVE_ONLY, false, TypeFormatConstants.FillMode.ZEROES);
            }
            if (norm.length() == 2 && (chr = norm.charAt(1)) > '\u0000' && chr <= '9') {
                return new ImpliedDecimalFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.NEGATIVE_ONLY, false, TypeFormatConstants.FillMode.ZEROES, chr - 48);
            }
        } else {
            if ("ID".equals(norm)) {
                return new GeneralStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.NONE);
            }
            if ("DT".equals(norm)) {
                return new X12DateFormat(type, minLength, maxLength);
            }
            if ("TM".equals(norm)) {
                return new MillisecondTimeFormat(type, minLength, maxLength);
            }
            if ("B".equals(norm)) {
                return new GeneralStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT);
            }
        }
        throw new IllegalArgumentException("Unknown X12 type code " + type);
    }

    static /* synthetic */ boolean[] access$000() {
        return basicCharacterSet;
    }

    static /* synthetic */ boolean[] access$100() {
        return extendedCharacterSet;
    }

    static {
        EdiConstants.fillChars((char)'A', (char)'Z', (boolean[])basicCharacterSet);
        EdiConstants.fillChars((char)'0', (char)'9', (boolean[])basicCharacterSet);
        EdiConstants.setChars((char[])" !|&'()*+,-./:;?=\"".toCharArray(), (boolean[])basicCharacterSet);
        extendedCharacterSet = new boolean[256];
        System.arraycopy(basicCharacterSet, 0, extendedCharacterSet, 0, basicCharacterSet.length);
        EdiConstants.fillChars((char)'a', (char)'z', (boolean[])extendedCharacterSet);
        EdiConstants.setChars((char[])"%@[]_{}\\<>~^`#$\u00c0\u00c1\u00c2\u00c4\u00e0\u00e1\u00e2\u00e4\u00c8\u00c9\u00ca\u00e8\u00e9\u00ea\u00eb\u00cc\u00cd\u00ce\u00ec\u00ed\u00ee\u00ef\u00d2\u00d3\u00d4\u00d6\u00f2\u00f3\u00f4\u00f6\u00d9\u00da\u00db\u00dc\u00f9\u00fa\u00fb\u00fc\u00c7\u00e7\u00d1\u00f1\u00bf\u00a1".toCharArray(), (boolean[])extendedCharacterSet);
        VALID1 = X12Constants.buildType("ID", 1, 1);
        VALID1_2 = X12Constants.buildType("ID", 1, 2);
        VALID2 = X12Constants.buildType("ID", 2, 2);
        VALID3 = X12Constants.buildType("ID", 3, 3);
        VALID5 = X12Constants.buildType("ID", 5, 5);
        VALAN1 = X12Constants.buildType("AN", 1, 1);
        VALAN1_12 = X12Constants.buildType("AN", 1, 12);
        VALAN1_35 = X12Constants.buildType("AN", 1, 35);
        VALAN2_15 = X12Constants.buildType("AN", 2, 15);
        VALAN4_9 = X12Constants.buildType("AN", 4, 9);
        VALAN10 = X12Constants.buildType("AN", 10, 10);
        VALAN15 = X12Constants.buildType("AN", 15, 15);
        VALDT6 = X12Constants.buildType("DT", 6, 6);
        VALDT6_8 = X12Constants.buildType("DT", 6, 8);
        VALTM4 = X12Constants.buildType("TM", 4, 4);
        VALTM4_8 = X12Constants.buildType("TM", 4, 8);
        VALN9 = X12Constants.buildType("N", 9, 9);
        VALN1_5 = X12Constants.buildType("N", 1, 5);
        VALN1_9 = X12Constants.buildType("N", 1, 9);
    }

    public static enum ErrorType {
        INTERCHANGE_NOTE,
        GROUP_SYNTAX,
        TRANSACTION_SYNTAX,
        SEGMENT_SYNTAX,
        ELEMENT_SYNTAX;

    }

    public static enum ErrorLevel {
        ROOT_LEVEL,
        INTERCHANGE_LEVEL,
        GROUP_LEVEL,
        TRANSACTION_LEVEL;

    }

    public static enum CharacterRestriction {
        BASIC(X12Constants.access$000()),
        EXTENDED(X12Constants.access$100()),
        UNRESTRICTED(null);

        private final boolean[] characterFlags;

        private CharacterRestriction(boolean[] flags) {
            this.characterFlags = flags;
        }

        public boolean[] flags() {
            return this.characterFlags;
        }
    }
}

