/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.x12;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.x12.X12Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class X12Lexer
extends DelimiterLexer {
    public X12Lexer(InputStream is, Charset charset) {
        super(is, -1);
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
    }

    public void configure(int subst, X12Constants.CharacterRestriction chset) {
        this.substitutionChar = subst;
        this.allowedChars = chset.flags();
    }

    public void handleEscape(StringBuilder builder) {
        throw new RuntimeException("Not used for X12");
    }

    private static InterchangeStartStatus replaceValidStatus(InterchangeStartStatus status, InterchangeStartStatus replace) {
        if (status == InterchangeStartStatus.VALID) {
            return replace;
        }
        return status;
    }

    public InterchangeStartStatus init(Map<String, Object> props) {
        try {
            int value = this.reader.read();
            while (value == 10 || value == 13 || value == 32) {
                value = this.reader.read();
            }
            if (value < 0) {
                return InterchangeStartStatus.NO_DATA;
            }
            char[] chrs = new char[]{(char)value, (char)this.reader.read(), (char)this.reader.read()};
            String tag = new String(chrs);
            if (!"ISA".equals(tag)) {
                throw new IllegalStateException("Message is missing ISA segment (starts with " + tag + ")");
            }
            this.dataSeparator = (char)this.reader.read();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            InterchangeStartStatus result = InterchangeStartStatus.VALID;
            try {
                props.put("ISA01", X12Constants.VALID2.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.AUTHORIZATION_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA02", X12Constants.VALAN10.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.AUTHORIZATION_INFO_ERROR);
            }
            this.advance();
            try {
                props.put("ISA03", X12Constants.VALID2.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SECURITY_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA04", X12Constants.VALAN10.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SECURITY_INFO_ERROR);
            }
            this.advance();
            try {
                props.put("ISA05", X12Constants.VALID2.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SENDER_ID_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA06", X12Constants.VALAN15.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.SENDER_ID_ERROR);
            }
            this.advance();
            try {
                props.put("ISA07", X12Constants.VALID2.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.RECEIVER_ID_QUALIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("ISA08", X12Constants.VALAN15.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.RECEIVER_ID_ERROR);
            }
            this.advance();
            try {
                props.put("ISA09", X12Constants.VALDT6.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.INTERCHANGE_DATE_ERROR);
            }
            this.advance();
            try {
                props.put("ISA10", (int)((Integer)X12Constants.VALTM4.parse((LexerBase)this)));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.INTERCHANGE_TIME_ERROR);
            }
            this.advance();
            String sep = X12Constants.VALAN1.parse((LexerBase)this).toString();
            props.put("ISA11", sep);
            this.repetitionSeparator = "U".equals(sep) ? -1 : (int)sep.charAt(0);
            this.advance();
            try {
                props.put("ISA12", X12Constants.VALID5.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.VERSION_ID_ERROR);
            }
            this.advance();
            try {
                props.put("ISA13", X12Constants.VALN9.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                throw new LexicalException("Interchange aborted due to Interchange Control Number error", (Throwable)e);
            }
            this.advance();
            try {
                props.put("ISA14", X12Constants.VALID1.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.ACK_REQUESTED_ERROR);
            }
            this.advance();
            String indicator = X12Constants.VALAN1.parse((LexerBase)this).toString();
            if (indicator.length() != 1 || !"I".equals(indicator) && !"P".equals(indicator) && !"T".equals(indicator)) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.TEST_INDICATOR_ERROR);
            }
            props.put("ISA15", indicator);
            this.componentSeparator = (char)this.reader.read();
            props.put("ISA16", Character.toString(this.componentSeparator));
            this.segmentTerminator = (char)this.reader.read();
            this.groupCount = 0;
            this.advance(EdiConstants.ItemType.SEGMENT);
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    public InterchangeStartStatus initWithGroupAndSetHeaders(Map<String, Object> props) {
        InterchangeStartStatus result = this.init(props);
        if (result == InterchangeStartStatus.VALID) {
            ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
            result = this.initGroups(groups, result);
            if (groups.size() > 0) {
                props.put("Groups", groups);
            }
        }
        return result;
    }

    private InterchangeStartStatus initGroups(List<Map<String, Object>> groupList, InterchangeStartStatus result) {
        try {
            while (!"IEA".equals(this.segmentTag())) {
                if ("GS".equals(this.segmentTag())) {
                    HashMap<String, Object> groupProps = new HashMap<String, Object>();
                    if ((result = this.initGroup(groupProps, result)) == InterchangeStartStatus.VALID) {
                        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
                        result = this.initTransactionSets(groups, result);
                        if (groups.size() > 0) {
                            groupProps.put("TransactionSets", groups);
                        }
                    }
                    groupList.add(groupProps);
                }
                this.advance(EdiConstants.ItemType.SEGMENT);
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    private InterchangeStartStatus initGroup(Map<String, Object> props, InterchangeStartStatus result) {
        try {
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            try {
                props.put("GS01", X12Constants.VALID2.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_FUNCTIONAL_IDENTIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("GS02", X12Constants.VALAN2_15.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_APPLICATION_SENDER_ERROR);
            }
            this.advance();
            try {
                props.put("GS03", X12Constants.VALAN2_15.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_APPLICATION_RECEIVER_ERROR);
            }
            this.advance();
            try {
                props.put("GS04", X12Constants.VALDT8.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_DATE_ERROR);
            }
            this.advance();
            try {
                props.put("GS05", X12Constants.VALTM4_8.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_TIME_ERROR);
            }
            this.advance();
            try {
                props.put("GS06", X12Constants.VALN1_9.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_CONTROL_NUMBER_ERROR);
            }
            this.advance();
            try {
                props.put("GS07", X12Constants.VALID1_2.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_RESPONSIBLE_AGENCY_ERROR);
            }
            this.advance();
            try {
                props.put("GS09", X12Constants.VALAN1_12.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.GROUP_VERSION_RELEASE_INDUSTRY_IDENTIFIER_ERROR);
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    private InterchangeStartStatus initTransactionSets(List<Map<String, Object>> txSetList, InterchangeStartStatus result) {
        try {
            while (!"GE".equals(this.segmentTag())) {
                if ("ST".equals(this.segmentTag())) {
                    HashMap<String, Object> txSetProps = new HashMap<String, Object>();
                    result = this.initTransactionSet(txSetProps, result);
                    txSetList.add(txSetProps);
                }
                this.advance(EdiConstants.ItemType.SEGMENT);
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    private InterchangeStartStatus initTransactionSet(Map<String, Object> props, InterchangeStartStatus result) {
        try {
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            try {
                props.put("Transaction set identifier code", X12Constants.VALID3.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.TRANSACTION_SET_IDENTIFIER_ERROR);
            }
            this.advance();
            try {
                props.put("Transaction set control number", X12Constants.VALAN4_9.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.TRANSACTION_SET_CONTROL_NUMBER_ERROR);
            }
            this.advance();
            try {
                props.put("Implementation convention reference", X12Constants.VALAN1_35.parse((LexerBase)this));
            }
            catch (LexicalException e) {
                result = X12Lexer.replaceValidStatus(result, InterchangeStartStatus.IMPLEMENTATION_CONVENTION_REFERENCE_ERROR);
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Interchange aborted due to error reading header", e);
        }
    }

    public InterchangeEndStatus term(Map<String, Object> props) throws IOException {
        if (!"IEA".equals(this.segmentTag())) {
            throw new IllegalStateException("not at trailer");
        }
        this.advance();
        int count = (Integer)X12Constants.VALN1_5.parse((LexerBase)this);
        if (count != this.groupCount) {
            return InterchangeEndStatus.GROUP_COUNT_ERROR;
        }
        this.advance();
        int number = (Integer)X12Constants.VALN9.parse((LexerBase)this);
        Object expected = props.get("ISA13");
        if (!(expected instanceof Integer)) {
            throw new IllegalStateException("ISA13 value must be an Integer");
        }
        if ((Integer)expected != number) {
            return InterchangeEndStatus.CONTROL_NUMBER_ERROR;
        }
        return InterchangeEndStatus.VALID;
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }

    public static enum InterchangeStartStatus {
        VALID,
        AUTHORIZATION_QUALIFIER_ERROR,
        AUTHORIZATION_INFO_ERROR,
        SECURITY_QUALIFIER_ERROR,
        SECURITY_INFO_ERROR,
        SENDER_ID_QUALIFIER_ERROR,
        SENDER_ID_ERROR,
        RECEIVER_ID_QUALIFIER_ERROR,
        RECEIVER_ID_ERROR,
        INTERCHANGE_DATE_ERROR,
        INTERCHANGE_TIME_ERROR,
        VERSION_ID_ERROR,
        INTER_CONTROL_ERROR,
        ACK_REQUESTED_ERROR,
        TEST_INDICATOR_ERROR,
        GROUP_FUNCTIONAL_IDENTIFIER_ERROR,
        GROUP_APPLICATION_SENDER_ERROR,
        GROUP_APPLICATION_RECEIVER_ERROR,
        GROUP_DATE_ERROR,
        GROUP_TIME_ERROR,
        GROUP_CONTROL_NUMBER_ERROR,
        GROUP_RESPONSIBLE_AGENCY_ERROR,
        GROUP_VERSION_RELEASE_INDUSTRY_IDENTIFIER_ERROR,
        TRANSACTION_SET_IDENTIFIER_ERROR,
        TRANSACTION_SET_CONTROL_NUMBER_ERROR,
        IMPLEMENTATION_CONVENTION_REFERENCE_ERROR,
        NO_DATA;

    }
}

