/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.x12;

import com.mulesoft.flatfile.lexical.DelimiterWriter;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.x12.X12Constants;
import com.mulesoft.flatfile.lexical.x12.X12Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class X12Writer
extends DelimiterWriter {
    private char isa11Character;

    public X12Writer(OutputStream os, Charset encoding, char datasep, char subsep, int repsep, char segterm, String segsep, int subst, X12Constants.CharacterRestriction chset, char isa11Character) {
        super(os, encoding, datasep, subsep, -1, repsep, segterm, segsep, -1, -1, subst, '.', chset.flags());
        this.isa11Character = isa11Character;
    }

    public X12Writer(OutputStream os, Charset encoding, char datasep, char subsep, int repsep, char segterm, String segsep, int subst, X12Constants.CharacterRestriction chset) {
        this(os, encoding, datasep, subsep, repsep, segterm, segsep, subst, chset, (char)(repsep > 0 ? (int)repsep : 85));
    }

    public String convertEscape(char chr) throws WriteException {
        throw new WriteException("unsupported character in data " + chr);
    }

    private void writeInterchangeControlNumber(Map<String, Object> props) throws IOException {
        try {
            X12Constants.VALN9.write(X12Writer.getRequired((String)"ISA13", props), (WriterBase)this);
        }
        catch (LexicalDataException lde) {
            throw new WriteException(lde.getMessage() + " for property '" + "ISA13" + "'");
        }
    }

    private Calendar getCalendar(Object value, Calendar defaultVal, String name) throws WriteException {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof Instant) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(((Instant)value).toEpochMilli());
            return calendar;
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            return calendar;
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zoned = (ZonedDateTime)value;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(zoned.toInstant().toEpochMilli());
            return calendar;
        }
        throw new WriteException("incompatible type for supplied value object: " + value.getClass().getName() + " for property '" + name + "' - expected Calendar or Date-type value");
    }

    private void writeDirect(Object value, TypeFormat vtype, String name) throws IOException {
        try {
            vtype.write(value, (WriterBase)this);
        }
        catch (LexicalDataException e) {
            throw new LexicalDataException(e, name);
        }
        this.writeDataSeparator();
    }

    public void init(Map<String, Object> props) throws IOException {
        int millis;
        this.writer.write("ISA");
        this.writeDataSeparator();
        this.writeProperty("ISA01", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA02", props, "", X12Constants.VALAN10);
        this.writeProperty("ISA03", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA04", props, "", X12Constants.VALAN10);
        this.writeProperty("ISA05", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA06", props, null, X12Constants.VALAN15);
        this.writeProperty("ISA07", props, "00", X12Constants.VALID2);
        this.writeProperty("ISA08", props, null, X12Constants.VALAN15);
        GregorianCalendar defaultCalendar = new GregorianCalendar();
        Calendar date = this.getCalendar(props.get("ISA09"), defaultCalendar, "ISA09");
        this.writeDirect(date, X12Constants.VALDT6, "ISA09");
        Object tvalue = props.get("ISA10");
        if (tvalue == null) {
            millis = (date.get(11) * 60 + date.get(12)) * 60 * 1000;
        } else if (tvalue instanceof Integer) {
            millis = (Integer)tvalue;
        } else {
            throw new WriteException("incompatible type for supplied value object: " + tvalue.getClass().getName() + " for property '" + "ISA10" + "' - expected Integer value (time in milliseconds)");
        }
        this.writeDirect(millis, X12Constants.VALTM4, "ISA10");
        Object version = X12Writer.getRequired((String)"ISA12", props);
        if (!(version instanceof String)) {
            throw new WriteException("incompatible type for supplied value object: " + version.getClass().getName() + " for property '" + "ISA12" + "' - expected String value");
        }
        char repetitionChar = X12Utils.validateISA11CharacterByVersion(version.toString(), this.isa11Character);
        this.writer.write(repetitionChar);
        this.writeDataSeparator();
        this.writeDirect(version, X12Constants.VALID5, "ISA10");
        this.writeInterchangeControlNumber(props);
        this.writeDataSeparator();
        this.writeProperty("ISA14", props, "1", X12Constants.VALID1);
        this.writeProperty("ISA15", props, "P", X12Constants.VALID1);
        this.writeComponentSeparator();
        this.writeSegmentTerminator();
        this.groupCount = 0;
    }

    public void term(Map<String, Object> props) throws IOException {
        this.writeToken("IEA");
        this.writeDataSeparator();
        X12Constants.VALN1_5.write((Object)this.groupCount, (WriterBase)this);
        this.writeDataSeparator();
        this.writeInterchangeControlNumber(props);
        this.writeSegmentTerminator();
    }
}

