/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.convert;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.x12.X12Constants;
import com.mulesoft.flatfile.schema.convert.X12TablesConverter;
import com.mulesoft.flatfile.schema.convert.X12TablesConverter$ComponentInfo$2$;
import com.mulesoft.flatfile.schema.convert.YamlWriterForX12$;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.DefinedPosition;
import com.mulesoft.flatfile.schema.model.DelimitedCompositeComponent;
import com.mulesoft.flatfile.schema.model.DelimitedElementComponent;
import com.mulesoft.flatfile.schema.model.DelimitedElementComponent$;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.EdiSchemaVersion;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.Element$;
import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.GroupComponent$;
import com.mulesoft.flatfile.schema.model.LoopWrapperComponent;
import com.mulesoft.flatfile.schema.model.OccurrenceRule;
import com.mulesoft.flatfile.schema.model.OccurrenceRule$;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent$;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Segment$;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import com.mulesoft.flatfile.schema.model.SegmentPosition;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.Structure$;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.model.Usage;
import com.mulesoft.flatfile.schema.model.Usage$;
import com.mulesoft.flatfile.schema.x12.X12Form$;
import com.mulesoft.flatfile.schema.x12.X12FormConverter$;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class X12TablesConverter$ {
    public static X12TablesConverter$ MODULE$;
    private final String yamlExtension;
    private final String codesExtension;
    private final String transHeadersName;
    private final String transDetailsName;
    private final String segmentHeadersName;
    private final String segmentDetailsName;
    private final String compositeHeadersName;
    private final String compositeDetailsName;
    private final String elementHeadersName;
    private final String elementDetailsName;
    private final String freeFormName;
    private final String segmentNoteText;
    private final String compositeNoteText;
    private final String codeSetText;
    private final String groupIdentSuffix;
    private final List<Tuple2<String, List<List<String>>>> emptyListOfKeyedLists;

    static {
        new X12TablesConverter$();
    }

    public String yamlExtension() {
        return this.yamlExtension;
    }

    public String codesExtension() {
        return this.codesExtension;
    }

    public String transHeadersName() {
        return this.transHeadersName;
    }

    public String transDetailsName() {
        return this.transDetailsName;
    }

    public String segmentHeadersName() {
        return this.segmentHeadersName;
    }

    public String segmentDetailsName() {
        return this.segmentDetailsName;
    }

    public String compositeHeadersName() {
        return this.compositeHeadersName;
    }

    public String compositeDetailsName() {
        return this.compositeDetailsName;
    }

    public String elementHeadersName() {
        return this.elementHeadersName;
    }

    public String elementDetailsName() {
        return this.elementDetailsName;
    }

    public String freeFormName() {
        return this.freeFormName;
    }

    public String segmentNoteText() {
        return this.segmentNoteText;
    }

    public String compositeNoteText() {
        return this.compositeNoteText;
    }

    public String codeSetText() {
        return this.codeSetText;
    }

    public String groupIdentSuffix() {
        return this.groupIdentSuffix;
    }

    public List<String> splitValues(String s) {
        return X12TablesConverter$.splitQuotes$1((Seq)Predef$.MODULE$.wrapString(s), (List)Nil$.MODULE$, s);
    }

    public FileInputStream fileInput(File dir, String name) {
        return new FileInputStream(new File(dir, name));
    }

    public <T> T foldInput(InputStream in, T z2, Function2<T, List<String>, T> f) {
        return (T)Source$.MODULE$.fromInputStream(in, "ISO-8859-1").getLines().filter((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$foldInput$1(line))).foldLeft(z2, (Function2 & Serializable & scala.Serializable)(z, line) -> f.apply(z, MODULE$.splitValues((String)line)));
    }

    public scala.collection.immutable.Map<String, String> nameMap(InputStream in) {
        return this.foldInput(in, Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(map, list) -> {
            String name;
            String number;
            block3: {
                block2: {
                    List list2 = list;
                    if (!(list2 instanceof .colon.colon)) break block2;
                    .colon.colon colon2 = (.colon.colon)list2;
                    number = (String)colon2.head();
                    List list3 = colon2.tl$access$1();
                    if (!(list3 instanceof .colon.colon)) break block2;
                    .colon.colon colon3 = (.colon.colon)list3;
                    name = (String)colon3.head();
                    List list4 = colon3.tl$access$1();
                    if (Nil$.MODULE$.equals(list4)) break block3;
                }
                throw new IllegalArgumentException("wrong number of values in file");
            }
            scala.collection.immutable.Map map2 = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)number), (Object)name));
            return map2;
        });
    }

    public List<Tuple2<String, List<List<String>>>> emptyListOfKeyedLists() {
        return this.emptyListOfKeyedLists;
    }

    public X12TablesConverter.SyntaxRule parseSyntaxRule(String line) {
        String code = line.substring(0, 1);
        Buffer indexes = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int index = 1; index < line.length(); index += 2) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = indexes.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(line.substring(index, index + 2))).toInt()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return new X12TablesConverter.SyntaxRule(code, (List<Object>)indexes.toList());
    }

    public Tuple3<scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>>, scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>>, scala.collection.immutable.Map<String, List<Tuple2<String, String>>>> parseFreeform(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, "ISO-8859-1").getLines();
        scala.collection.immutable.Map test = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Map segRules = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map compRules = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map codeSets = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set partitionSets = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (lines.nonEmpty()) {
            BoxedUnit boxedUnit;
            String string = (String)lines.next();
            String string2 = this.segmentNoteText();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                BoxedUnit boxedUnit2;
                String[] codes = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).split(',');
                String string4 = codes[2];
                String string5 = "N";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    Buffer buff = (Buffer)segRules.getOrElseUpdate((Object)codes[0], (Function0 & Serializable & scala.Serializable)() -> (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                    boxedUnit2 = buff.$plus$eq((Object)this.parseSyntaxRule((String)lines.next()));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            String string6 = this.compositeNoteText();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                BoxedUnit boxedUnit3;
                String[] codes = new StringOps(Predef$.MODULE$.augmentString((String)lines.next())).split(',');
                String string8 = codes[2];
                String string9 = "N";
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    Buffer buff = (Buffer)compRules.getOrElseUpdate((Object)codes[0], (Function0 & Serializable & scala.Serializable)() -> (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                    boxedUnit3 = buff.$plus$eq((Object)this.parseSyntaxRule((String)lines.next()));
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit3;
                continue;
            }
            String string10 = this.codeSetText();
            String string11 = string;
            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                int partition;
                String line = (String)lines.next();
                String[] codes = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                String part = codes[1].trim();
                int n = partition = part.isEmpty() ? 0 : new StringOps(Predef$.MODULE$.augmentString(part)).toInt();
                if (partition < 0 || partition > 2) {
                    throw new IllegalArgumentException(new StringBuilder(33).append("Invalid partition value in input ").append(line).toString());
                }
                String id2 = codes[0];
                Object object = partition > 0 ? partitionSets.$plus$eq((Object)id2) : BoxedUnit.UNIT;
                String name = ((String)lines.next()).trim();
                Buffer buff = (Buffer)codeSets.getOrElseUpdate((Object)id2, (Function0 & Serializable & scala.Serializable)() -> (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                boxedUnit = buff.$plus$eq((Object)new X12TablesConverter.CodeValue(partition, codes[2], name));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        Map segs = (Map)segRules.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Buffer v = (Buffer)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toList());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Map comps = (Map)compRules.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Buffer v = (Buffer)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toList());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        partitionSets.foreach((Function1 & Serializable & scala.Serializable)id -> {
            Buffer partValues = (Buffer)codeSets.apply(id);
            Buffer merged = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer part1s = (Buffer)partValues.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$parseFreeform$7(x$3)));
            Buffer part2s = (Buffer)partValues.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$parseFreeform$8(x$4)));
            part1s.foreach((Function1 & Serializable & scala.Serializable)cv1 -> {
                X12TablesConverter$.$anonfun$parseFreeform$9(merged, part2s, cv1);
                return BoxedUnit.UNIT;
            });
            return codeSets.put(id, (Object)merged);
        });
        Map sets = (Map)codeSets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Buffer v = (Buffer)tuple2._2();
            List set = (List)v.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$4, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                List cs = (List)tuple2._1();
                X12TablesConverter.CodeValue codeValue = (X12TablesConverter.CodeValue)tuple2._2();
                if (codeValue == null) throw new MatchError((Object)tuple2);
                int index = codeValue.index();
                String code = codeValue.code();
                String name = codeValue.name();
                int n = index;
                switch (n) {
                    case 0: {
                        Tuple2 tuple22 = new Tuple2((Object)code, (Object)name);
                        return cs.$colon$colon((Object)tuple22);
                    }
                    default: {
                        throw new IllegalStateException(new StringBuilder(35).append("Error consolidating values for key ").append(k).toString());
                    }
                }
            });
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)set);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new Tuple3((Object)segs.toMap(Predef$.MODULE$.$conforms()), (Object)comps.toMap(Predef$.MODULE$.$conforms()), (Object)sets.toMap(Predef$.MODULE$.$conforms()));
    }

    public List<Tuple2<String, List<List<String>>>> gatherGroups(String source, InputStream in, int count, Option<String> fill) {
        List<Tuple2<String, List<List<String>>>> result = this.foldInput(in, this.emptyListOfKeyedLists(), (Function2 & Serializable & scala.Serializable)(acc, list) -> {
            int length = list.length();
            boolean bl = false;
            .colon.colon colon2 = null;
            List list2 = list;
            if (list2 instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list2;
                String id = (String)colon2.head();
                List rest = colon2.tl$access$1();
                if (length == count) {
                    return X12TablesConverter$.append$1(id, rest, acc);
                }
            }
            if (!bl) throw new IllegalArgumentException(new StringBuilder(34).append("wrong number of values in input ").append(source).append(": ").append(list).toString());
            String id = (String)colon2.head();
            List rest = colon2.tl$access$1();
            if (!fill.nonEmpty()) throw new IllegalArgumentException(new StringBuilder(34).append("wrong number of values in input ").append(source).append(": ").append(list).toString());
            if (length != count - 1) throw new IllegalArgumentException(new StringBuilder(34).append("wrong number of values in input ").append(source).append(": ").append(list).toString());
            return X12TablesConverter$.append$1(id, (List)rest.$colon$plus(fill.get(), List$.MODULE$.canBuildFrom()), acc);
        });
        return (List)result.foldLeft(this.emptyListOfKeyedLists(), (Function2 & Serializable & scala.Serializable)(acc, pair) -> {
            Tuple2 tuple2 = pair;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List list = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)list.reverse());
            List list2 = acc.$colon$colon((Object)tuple22);
            return list2;
        });
    }

    public List<OccurrenceRule> buildRules(Option<List<X12TablesConverter.SyntaxRule>> rules, List<SegmentComponent> comps) {
        Nil$ nil$;
        Option<List<X12TablesConverter.SyntaxRule>> option = rules;
        if (option instanceof Some) {
            Some some = (Some)option;
            List l = (List)some.value();
            nil$ = (List)l.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                OccurrenceRule.OneOrMore oneOrMore;
                X12TablesConverter.SyntaxRule syntaxRule = x0$1;
                if (syntaxRule == null) throw new MatchError((Object)syntaxRule);
                String code = syntaxRule.code();
                List<Object> indexes = syntaxRule.indexes();
                List rcomps = (List)indexes.map((Function1 & Serializable & scala.Serializable)index -> X12TablesConverter$.$anonfun$buildRules$2(comps, l, BoxesRunTime.unboxToInt((Object)index)), List$.MODULE$.canBuildFrom());
                String string = code;
                String string2 = OccurrenceRule$.MODULE$.OneOrMoreCode();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    oneOrMore = new OccurrenceRule.OneOrMore(rcomps, X12Form$.MODULE$.inlineComposites());
                    return oneOrMore;
                }
                String string4 = OccurrenceRule$.MODULE$.IfFirstThenAllCode();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    oneOrMore = new OccurrenceRule.IfFirstThenAll(rcomps, X12Form$.MODULE$.inlineComposites());
                    return oneOrMore;
                }
                String string6 = OccurrenceRule$.MODULE$.OneOrNoneCode();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    oneOrMore = new OccurrenceRule.OneOrNone(rcomps, X12Form$.MODULE$.inlineComposites());
                    return oneOrMore;
                }
                String string8 = OccurrenceRule$.MODULE$.IfFirstThenMoreCode();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    oneOrMore = new OccurrenceRule.IfFirstThenMore(rcomps, X12Form$.MODULE$.inlineComposites());
                    return oneOrMore;
                }
                String string10 = OccurrenceRule$.MODULE$.AllOrNoneCode();
                String string11 = string;
                if (string10 == null) {
                    if (string11 != null) {
                        throw new IllegalArgumentException(new StringBuilder(25).append("invalid syntax note code ").append(code).toString());
                    }
                } else if (!string10.equals(string11)) throw new IllegalArgumentException(new StringBuilder(25).append("invalid syntax note code ").append(code).toString());
                oneOrMore = new OccurrenceRule.AllOrNone(rcomps, X12Form$.MODULE$.inlineComposites());
                return oneOrMore;
            }, List$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public ListMap<String, Composite> defineComposites(scala.collection.immutable.Map<String, String> elemNames, scala.collection.immutable.Map<String, Element> elements, scala.collection.immutable.Map<String, String> compNames, List<Tuple2<String, List<List<String>>>> groups, scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>> compRules) {
        List list = (List)((SeqLike)groups.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(acc2, pair) -> {
            Tuple2 tuple2 = pair;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List list = (List)tuple2._2();
            List comps = ((List)list.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(acc, vals) -> {
                String req;
                String elem;
                String pos;
                block3: {
                    block2: {
                        List list = vals;
                        if (!(list instanceof .colon.colon)) break block2;
                        .colon.colon colon2 = (.colon.colon)list;
                        pos = (String)colon2.head();
                        List list2 = colon2.tl$access$1();
                        if (!(list2 instanceof .colon.colon)) break block2;
                        .colon.colon colon3 = (.colon.colon)list2;
                        elem = (String)colon3.head();
                        List list3 = colon3.tl$access$1();
                        if (!(list3 instanceof .colon.colon)) break block2;
                        .colon.colon colon4 = (.colon.colon)list3;
                        req = (String)colon4.head();
                        List list4 = colon4.tl$access$1();
                        if (Nil$.MODULE$.equals(list4)) break block3;
                    }
                    throw new IllegalStateException("wrong number of items in list");
                }
                int position = new StringOps(Predef$.MODULE$.augmentString(pos)).toInt();
                String elemKey = X12Form$.MODULE$.keyName(key, "", "", position);
                DelimitedElementComponent delimitedElementComponent = new DelimitedElementComponent((Element)elements.apply((Object)elem), (Option)None$.MODULE$, elemKey, position, Usage$.MODULE$.convertUsage(req), 1, DelimitedElementComponent$.MODULE$.apply$default$7(), DelimitedElementComponent$.MODULE$.apply$default$8());
                List list = acc.$colon$colon((Object)delimitedElementComponent);
                return list;
            })).reverse();
            List<OccurrenceRule> rules = MODULE$.buildRules((Option<List<X12TablesConverter.SyntaxRule>>)compRules.get((Object)key), (List<SegmentComponent>)comps);
            Composite composite = new Composite(key, (String)compNames.apply((Object)key), comps, rules, 0);
            List list2 = acc2.$colon$colon((Object)composite);
            return list2;
        })).sortBy((Function1 & Serializable & scala.Serializable)x$14 -> x$14.ident(), (Ordering)Ordering.String$.MODULE$);
        return (ListMap)list.foldLeft((Object)ListMap$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(map, comp) -> map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)comp.ident()), comp)));
    }

    public ListMap<String, Segment> defineSegments(scala.collection.immutable.Map<String, String> elemNames, scala.collection.immutable.Map<String, Element> elements, scala.collection.immutable.Map<String, String> compNames, scala.collection.immutable.Map<String, Composite> composites, scala.collection.immutable.Map<String, String> segNames, scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>> segRules, List<Tuple2<String, List<List<String>>>> groups) {
        List list = (List)((SeqLike)groups.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(acc2, pair) -> {
            Tuple2 tuple2 = pair;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List list = (List)tuple2._2();
            List comps = ((List)list.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(acc, vals) -> {
                List list;
                List list2 = vals;
                if (!(list2 instanceof .colon.colon)) throw new IllegalStateException("wrong number of items in list");
                .colon.colon colon2 = (.colon.colon)list2;
                String pos = (String)colon2.head();
                List list3 = colon2.tl$access$1();
                if (!(list3 instanceof .colon.colon)) throw new IllegalStateException("wrong number of items in list");
                .colon.colon colon3 = (.colon.colon)list3;
                String ident = (String)colon3.head();
                List list4 = colon3.tl$access$1();
                if (!(list4 instanceof .colon.colon)) throw new IllegalStateException("wrong number of items in list");
                .colon.colon colon4 = (.colon.colon)list4;
                String req = (String)colon4.head();
                List list5 = colon4.tl$access$1();
                if (!(list5 instanceof .colon.colon)) throw new IllegalStateException("wrong number of items in list");
                .colon.colon colon5 = (.colon.colon)list5;
                String reps = (String)colon5.head();
                List list6 = colon5.tl$access$1();
                if (!Nil$.MODULE$.equals(list6)) throw new IllegalStateException("wrong number of items in list");
                int count = new StringOps(Predef$.MODULE$.augmentString(reps)).toInt();
                String string = req;
                String string2 = "X";
                Usage.OptionalUsage$ usage = !(string != null ? !string.equals(string2) : string2 != null) ? Usage.OptionalUsage$.MODULE$ : Usage$.MODULE$.convertUsage(req);
                int position = new StringOps(Predef$.MODULE$.augmentString(pos)).toInt();
                String compKey = X12Form$.MODULE$.keyName(key, "", "", position);
                if (elements.contains((Object)ident)) {
                    DelimitedElementComponent delimitedElementComponent = new DelimitedElementComponent((Element)elements.apply((Object)ident), (Option)None$.MODULE$, compKey, position, (Usage)usage, count, DelimitedElementComponent$.MODULE$.apply$default$7(), DelimitedElementComponent$.MODULE$.apply$default$8());
                    list = acc.$colon$colon((Object)delimitedElementComponent);
                    return list;
                } else {
                    DelimitedCompositeComponent delimitedCompositeComponent = new DelimitedCompositeComponent((Composite)composites.apply((Object)ident), (Option)None$.MODULE$, compKey, position, (Usage)usage, count);
                    list = acc.$colon$colon((Object)delimitedCompositeComponent);
                }
                return list;
            })).reverse();
            List<OccurrenceRule> rules = MODULE$.buildRules((Option<List<X12TablesConverter.SyntaxRule>>)segRules.get((Object)key), (List<SegmentComponent>)comps);
            Segment segment = Segment$.MODULE$.apply(key, (String)segNames.apply((Object)key), comps, rules);
            List list2 = acc2.$colon$colon((Object)segment);
            return list2;
        })).sortBy((Function1 & Serializable & scala.Serializable)x$18 -> x$18.tag(), (Ordering)Ordering.String$.MODULE$);
        return (ListMap)list.foldLeft((Object)ListMap$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(map, seg) -> map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)seg.tag()), seg)));
    }

    public scala.collection.immutable.Map<String, Structure> defineStructures(scala.collection.immutable.Map<String, Segment> segments, scala.collection.immutable.Map<String, Tuple2<String, String>> transHeads, List<Tuple2<String, List<List<String>>>> groups, scala.collection.immutable.Set<Segment> excludeSegs, EdiSchemaVersion version) {
        LazyRef ComponentInfo$module = new LazyRef();
        return (scala.collection.immutable.Map)groups.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            String key = (String)tuple22._1();
            List list = (List)tuple22._2();
            scala.collection.immutable.Map tables = ((scala.collection.immutable.Map)this.convertComponents$1(list, segments, ComponentInfo$module).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                List list = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)key, (Object)this.buildComps$1(key, list, excludeSegs));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Tuple2 tuple23 = (Tuple2)transHeads.apply((Object)key);
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            String name = (String)tuple23._1();
            String group = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)name, (Object)group);
            Tuple2 tuple25 = tuple24;
            String name2 = (String)tuple25._1();
            String group2 = (String)tuple25._2();
            return map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Structure$.MODULE$.apply(key, name2, (Option)new Some((Object)group2), X12TablesConverter$.optSeq$1(tables.get((Object)"1")), X12TablesConverter$.optSeq$1(tables.get((Object)"2")), X12TablesConverter$.optSeq$1(tables.get((Object)"3")), version)));
        });
    }

    public int convertLength(String text) {
        int n;
        int split = text.indexOf("E");
        if (split < 0) {
            n = new StringOps(Predef$.MODULE$.augmentString(text)).toInt();
        } else if (text.startsWith("(")) {
            int end = text.indexOf(")");
            int base = X12TablesConverter$.parseExponential$1(split - 1, text.substring(1, end));
            String adjust = text.substring(end + 1);
            n = adjust.isEmpty() ? base : base + new StringOps(Predef$.MODULE$.augmentString(adjust)).toInt();
        } else {
            n = X12TablesConverter$.parseExponential$1(split, text);
        }
        return n;
    }

    public void writeSchema(EdiSchema schema, String name, String[] imports, File outdir) {
        File file = new File(outdir, new StringBuilder(0).append(name).append(this.yamlExtension()).toString());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        YamlWriterForX12$.MODULE$.write(schema, imports, writer, false);
        writer.close();
    }

    public void verifySchema(EdiSchema baseSchema, String name, File outdir, YamlReader yamlrdr) {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(outdir, new StringBuilder(0).append(name).append(this.yamlExtension()).toString())), "UTF-8");
        EdiSchema readSchema = yamlrdr.loadYaml((Reader)reader, (List)new .colon.colon((Object)outdir.getParentFile().getParentFile().getParentFile().getAbsolutePath(), (List)Nil$.MODULE$));
    }

    public void main(String[] args) {
        Boolean bl;
        File x12dir = new File(args[0]);
        Predef$.MODULE$.println((Object)x12dir.getAbsolutePath());
        File yamldir = new File(args[1]);
        if (yamldir.exists()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])yamldir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)version -> {
                Object object;
                if (version.exists() && version.isDirectory()) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])version.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
                    object = BoxesRunTime.boxToBoolean((boolean)version.delete());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)yamldir.mkdirs());
        }
        YamlReader yamlrdr = new YamlReader((EdiFormConverter)X12FormConverter$.MODULE$);
        FileWriter versionWriter = new FileWriter(new File(yamldir, "versions.txt"));
        String specificVersion = args.length > 2 ? args[2] : "";
        File[] filesToProcess = specificVersion.isEmpty() ? x12dir.listFiles() : (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x12dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$main$3(specificVersion, x$27)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToProcess)).foreach((Function1 & Serializable & scala.Serializable)version -> {
            X12TablesConverter$.$anonfun$main$4(yamldir, yamlrdr, versionWriter, version);
            return BoxedUnit.UNIT;
        });
        versionWriter.close();
    }

    private static final List stripComma$1(Seq remain, List acc, String s$1) {
        List list;
        if (remain.isEmpty()) {
            list = acc.reverse();
        } else if (BoxesRunTime.unboxToChar((Object)remain.head()) == ',') {
            list = X12TablesConverter$.splitQuotes$1((Seq)remain.tail(), acc, s$1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(44).append("missing expected comma after closing quote: ").append(s$1).toString());
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$splitValues$1(char c) {
        return c != '\"';
    }

    private static final List splitQuotes$1(Seq remain, List acc, String s$1) {
        Seq rest;
        Seq text;
        if (BoxesRunTime.unboxToChar((Object)remain.head()) == '\"') {
            Tuple2 tuple2 = ((TraversableLike)remain.tail()).span((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$splitValues$1(BoxesRunTime.unboxToChar((Object)c))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq text2 = (Seq)tuple2._1();
            Seq rest2 = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)text2, (Object)rest2);
            Tuple2 tuple23 = tuple22;
            text = (Seq)tuple23._1();
            rest = (Seq)tuple23._2();
            if (rest.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(33).append("missing closing quote character: ").append(s$1).toString());
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(34).append("missing required quote character: ").append(s$1).toString());
        }
        String string = text.toString().replace('\u0092', '\'');
        return X12TablesConverter$.stripComma$1((Seq)rest.tail(), acc.$colon$colon((Object)string), s$1);
    }

    public static final /* synthetic */ boolean $anonfun$foldInput$1(String line) {
        return line.length() > 0 && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).head()) != '#';
    }

    public static final /* synthetic */ boolean $anonfun$parseFreeform$7(X12TablesConverter.CodeValue x$3) {
        return x$3.index() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$parseFreeform$8(X12TablesConverter.CodeValue x$4) {
        return x$4.index() == 2;
    }

    public static final /* synthetic */ void $anonfun$parseFreeform$9(Buffer merged$1, Buffer part2s$1, X12TablesConverter.CodeValue cv1) {
        merged$1.$plus$eq((Object)new X12TablesConverter.CodeValue(0, cv1.code(), cv1.name()));
        part2s$1.foreach((Function1 & Serializable & scala.Serializable)cv2 -> merged$1.$plus$eq((Object)new X12TablesConverter.CodeValue(0, new StringBuilder(0).append(cv1.code()).append(cv2.code()).toString(), new StringBuilder(3).append(cv1.name()).append(" / ").append(cv2.name()).toString())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final List append$1(String id, List next, List acc) {
        List list = acc;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List tail = colon2.tl$access$1();
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                List values = (List)tuple2._2();
                String string = key;
                String string2 = id;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    List list2 = next;
                    Tuple2 tuple22 = new Tuple2((Object)key, (Object)values.$colon$colon((Object)list2));
                    return tail.$colon$colon((Object)tuple22);
                }
            }
        }
        List list3 = next;
        Tuple2 tuple2 = new Tuple2((Object)id, (Object)Nil$.MODULE$.$colon$colon((Object)list3));
        return list.$colon$colon((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$buildRules$3(int index$1, SegmentComponent x$11) {
        return x$11.position() == index$1;
    }

    public static final /* synthetic */ SegmentComponent $anonfun$buildRules$2(List comps$1, List l$1, int index) {
        SegmentComponent c;
        Option option = comps$1.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$buildRules$3(index, x$11)));
        if (!(option instanceof Some)) {
            throw new IllegalArgumentException(new StringBuilder(29).append("position not found ").append(index).append(" in rule: ").append(l$1).toString());
        }
        Some some = (Some)option;
        SegmentComponent segmentComponent = c = (SegmentComponent)some.value();
        return segmentComponent;
    }

    private static final /* synthetic */ X12TablesConverter$ComponentInfo$2$ ComponentInfo$lzycompute$1(LazyRef ComponentInfo$module$1) {
        X12TablesConverter$ComponentInfo$2$ x12TablesConverter$ComponentInfo$2$;
        LazyRef lazyRef = ComponentInfo$module$1;
        synchronized (lazyRef) {
            x12TablesConverter$ComponentInfo$2$ = ComponentInfo$module$1.initialized() ? (X12TablesConverter$ComponentInfo$2$)((Object)ComponentInfo$module$1.value()) : (X12TablesConverter$ComponentInfo$2$)((Object)ComponentInfo$module$1.initialize((Object)new X12TablesConverter$ComponentInfo$2$()));
        }
        return x12TablesConverter$ComponentInfo$2$;
    }

    private final X12TablesConverter$ComponentInfo$2$ ComponentInfo$3(LazyRef ComponentInfo$module$1) {
        return ComponentInfo$module$1.initialized() ? (X12TablesConverter$ComponentInfo$2$)((Object)ComponentInfo$module$1.value()) : X12TablesConverter$.ComponentInfo$lzycompute$1(ComponentInfo$module$1);
    }

    /*
     * Unable to fully structure code
     */
    private final X12TablesConverter.ComponentInfo.1 info$1(String segid, String seq, String req, String max, String loopId, List nested, scala.collection.immutable.Map segments$1, LazyRef ComponentInfo$module$1) {
        segment = (Segment)segments$1.apply((Object)segid);
        v0 = req;
        var11_10 = "F";
        usage = !(v0 != null ? v0.equals(var11_10) == false : var11_10 != null) ? Usage.OptionalUsage$.MODULE$ : Usage$.MODULE$.convertUsage(req);
        v1 = max;
        var13_12 = ">1";
        if (!(v1 == null ? var13_12 != null : v1.equals(var13_12) == false)) ** GOTO lbl-1000
        v2 = max;
        var14_13 = "";
        if (!(v2 != null ? v2.equals(var14_13) == false : var14_13 != null)) lbl-1000:
        // 2 sources

        {
            v3 = 0;
        } else {
            v3 = new StringOps(Predef$.MODULE$.augmentString(max)).toInt();
        }
        repeat = v3;
        return this.ComponentInfo$3(ComponentInfo$module$1).apply(segment, seq, (Usage)usage, repeat, loopId, (List<X12TablesConverter.ComponentInfo.1>)nested);
    }

    private final Tuple2 descend$1(List remain, int depth, scala.collection.immutable.Map segments$1, LazyRef ComponentInfo$module$1) {
        return this.convertr$1(remain, depth, true, (List)Nil$.MODULE$, segments$1, ComponentInfo$module$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Tuple2 convertr$1(List remain, int depth, boolean loop, List acc, scala.collection.immutable.Map segments$1, LazyRef ComponentInfo$module$1) {
        List list;
        while ((list = remain) instanceof .colon.colon) {
            public class Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1
            implements Product,
            scala.Serializable {
                private final Segment segment;
                private final String seq;
                private final Usage usage;
                private final int repeat;
                private final String loopId;
                private final List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> loop;

                public Segment segment() {
                    return this.segment;
                }

                public String seq() {
                    return this.seq;
                }

                public Usage usage() {
                    return this.usage;
                }

                public int repeat() {
                    return this.repeat;
                }

                public String loopId() {
                    return this.loopId;
                }

                public List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> loop() {
                    return this.loop;
                }

                public Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1 copy(Segment segment, String seq, Usage usage, int repeat, String loopId, List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> loop) {
                    return new Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1(segment, seq, usage, repeat, loopId, loop);
                }

                public Segment copy$default$1() {
                    return this.segment();
                }

                public String copy$default$2() {
                    return this.seq();
                }

                public Usage copy$default$3() {
                    return this.usage();
                }

                public int copy$default$4() {
                    return this.repeat();
                }

                public String copy$default$5() {
                    return this.loopId();
                }

                public List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> copy$default$6() {
                    return this.loop();
                }

                public String productPrefix() {
                    return "ComponentInfo";
                }

                public int productArity() {
                    return 6;
                }

                public Object productElement(int x$1) {
                    Object object;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            object = this.segment();
                            break;
                        }
                        case 1: {
                            object = this.seq();
                            break;
                        }
                        case 2: {
                            object = this.usage();
                            break;
                        }
                        case 3: {
                            object = BoxesRunTime.boxToInteger((int)this.repeat());
                            break;
                        }
                        case 4: {
                            object = this.loopId();
                            break;
                        }
                        case 5: {
                            object = this.loop();
                            break;
                        }
                        default: {
                            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                        }
                    }
                    return object;
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1;
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.segment()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.seq()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.usage()));
                    n = Statics.mix((int)n, (int)this.repeat());
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.loopId()));
                    n = Statics.mix((int)n, (int)Statics.anyHash(this.loop()));
                    return Statics.finalizeHash((int)n, (int)6);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1 var4_4 = (Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1)x$1;
                    Segment segment = this.segment();
                    Segment segment2 = var4_4.segment();
                    if (segment == null) {
                        if (segment2 != null) {
                            return false;
                        }
                    } else if (!segment.equals(segment2)) return false;
                    String string = this.seq();
                    String string2 = var4_4.seq();
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    Usage usage = this.usage();
                    Usage usage2 = var4_4.usage();
                    if (usage == null) {
                        if (usage2 != null) {
                            return false;
                        }
                    } else if (!usage.equals(usage2)) return false;
                    if (this.repeat() != var4_4.repeat()) return false;
                    String string3 = this.loopId();
                    String string4 = var4_4.loopId();
                    if (string3 == null) {
                        if (string4 != null) {
                            return false;
                        }
                    } else if (!string3.equals(string4)) return false;
                    List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> list = this.loop();
                    List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> list2 = var4_4.loop();
                    if (list == null) {
                        if (list2 != null) {
                            return false;
                        }
                    } else if (!list.equals(list2)) return false;
                    if (!var4_4.canEqual(this)) return false;
                    return true;
                }

                public Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1(Segment segment, String seq, Usage usage, int repeat, String loopId, List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> loop) {
                    this.segment = segment;
                    this.seq = seq;
                    this.usage = usage;
                    this.repeat = repeat;
                    this.loopId = loopId;
                    this.loop = loop;
                    Product.$init$((Product)this);
                }
            }
            .colon.colon colon2;
            List list2;
            .colon.colon colon3 = (.colon.colon)list;
            List list3 = (List)colon3.head();
            List tail = colon3.tl$access$1();
            if (!(list3 instanceof .colon.colon) || !((list2 = (colon2 = (.colon.colon)list3).tl$access$1()) instanceof .colon.colon)) break;
            .colon.colon colon4 = (.colon.colon)list2;
            String seq = (String)colon4.head();
            List list4 = colon4.tl$access$1();
            if (!(list4 instanceof .colon.colon)) break;
            .colon.colon colon5 = (.colon.colon)list4;
            String segid = (String)colon5.head();
            List list5 = colon5.tl$access$1();
            if (!(list5 instanceof .colon.colon)) break;
            .colon.colon colon6 = (.colon.colon)list5;
            String req = (String)colon6.head();
            List list6 = colon6.tl$access$1();
            if (!(list6 instanceof .colon.colon)) break;
            .colon.colon colon7 = (.colon.colon)list6;
            String max = (String)colon7.head();
            List list7 = colon7.tl$access$1();
            if (!(list7 instanceof .colon.colon)) break;
            .colon.colon colon8 = (.colon.colon)list7;
            String level = (String)colon8.head();
            List list8 = colon8.tl$access$1();
            if (!(list8 instanceof .colon.colon)) break;
            .colon.colon colon9 = (.colon.colon)list8;
            String repeat = (String)colon9.head();
            List list9 = colon9.tl$access$1();
            if (!(list9 instanceof .colon.colon)) break;
            .colon.colon colon10 = (.colon.colon)list9;
            String loopid = (String)colon10.head();
            List list10 = colon10.tl$access$1();
            if (!Nil$.MODULE$.equals(list10)) break;
            String string = level;
            String string2 = " ";
            int at = !(string != null ? !string.equals(string2) : string2 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(level)).toInt();
            if (depth > at) return new Tuple2((Object)remain, (Object)acc);
            if (!loop && depth == at) {
                String string3 = loopid;
                String string4 = "";
                if (string3 == null ? string4 != null : !string3.equals(string4)) return new Tuple2((Object)remain, (Object)acc);
            }
            if (depth == at) {
                Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1 var40_38 = this.info$1(segid, seq, req, max, loopid, (List)Nil$.MODULE$, segments$1, ComponentInfo$module$1);
                acc = acc.$colon$colon((Object)var40_38);
                loop = false;
                depth = at;
                remain = tail;
                continue;
            }
            Tuple2 tuple2 = this.descend$1(remain, depth + 1, segments$1, ComponentInfo$module$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            List rest = (List)tuple2._1();
            List nested = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rest, (Object)nested);
            Tuple2 tuple23 = tuple22;
            List rest2 = (List)tuple23._1();
            List nested2 = (List)tuple23._2();
            Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1 var47_45 = this.info$1(segid, seq, req, repeat, loopid, nested2, segments$1, ComponentInfo$module$1);
            acc = acc.$colon$colon((Object)var47_45);
            loop = false;
            remain = rest2;
        }
        if (!Nil$.MODULE$.equals(list)) throw new IllegalArgumentException("wrong number of values");
        return new Tuple2((Object)Nil$.MODULE$, (Object)acc);
    }

    private final scala.collection.immutable.Map convertComponents$1(List rows, scala.collection.immutable.Map segments$1, LazyRef ComponentInfo$module$1) {
        return (scala.collection.immutable.Map)rows.groupBy((Function1 & Serializable & scala.Serializable)x$22 -> (String)x$22.head()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List list = (List)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), this.convertr$1(list, 0, false, (List)Nil$.MODULE$, segments$1, ComponentInfo$module$1)._2());
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    private final List descend$2(List remain, String area$1, scala.collection.immutable.Set excludeSegs$1) {
        return this.buildr$1(remain, (List)Nil$.MODULE$, area$1, excludeSegs$1);
    }

    private final List buildr$1(List remain, List acc, String area$1, scala.collection.immutable.Set excludeSegs$1) {
        List list;
        block9: {
            List list2;
            while ((list2 = remain) instanceof .colon.colon) {
                block13: {
                    List<Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1> loop;
                    String loopId;
                    int repeat;
                    Usage usage;
                    List tail;
                    block10: {
                        DefinedPosition position;
                        Segment segment;
                        block11: {
                            block14: {
                                Usage.MandatoryUsage$ mandatoryUsage$;
                                Usage usage2;
                                block12: {
                                    .colon.colon colon2 = (.colon.colon)list2;
                                    Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1 var10_7 = (Com_mulesoft_flatfile_schema_convert_X12TablesConverter$ComponentInfo$1)colon2.head();
                                    tail = colon2.tl$access$1();
                                    if (var10_7 == null) break;
                                    segment = var10_7.segment();
                                    String seq = var10_7.seq();
                                    usage = var10_7.usage();
                                    repeat = var10_7.repeat();
                                    loopId = var10_7.loopId();
                                    loop = var10_7.loop();
                                    if (!loop.isEmpty()) break block10;
                                    position = new DefinedPosition(area$1, seq);
                                    String string = segment.tag();
                                    String string2 = "LS";
                                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                        List list3 = acc;
                                        if (list3 instanceof .colon.colon) {
                                            .colon.colon colon3 = (.colon.colon)list3;
                                            StructureComponent group = (StructureComponent)colon3.head();
                                            List list4 = colon3.tl$access$1();
                                            if (group instanceof GroupComponent) {
                                                GroupComponent groupComponent = (GroupComponent)group;
                                                if (list4 instanceof .colon.colon) {
                                                    .colon.colon colon4 = (.colon.colon)list4;
                                                    StructureComponent leref = (StructureComponent)colon4.head();
                                                    List t = colon4.tl$access$1();
                                                    if (leref instanceof ReferenceComponent) {
                                                        LoopWrapperComponent wrap;
                                                        ReferenceComponent referenceComponent = (ReferenceComponent)leref;
                                                        String grpid = new StringOps(Predef$.MODULE$.augmentString(groupComponent.ident())).stripSuffix(this.groupIdentSuffix());
                                                        LoopWrapperComponent loopWrapperComponent = wrap = new LoopWrapperComponent(segment, referenceComponent.segment(), (SegmentPosition)position, referenceComponent.position(), (Usage)Usage.OptionalUsage$.MODULE$, grpid, groupComponent);
                                                        acc = t.$colon$colon((Object)loopWrapperComponent);
                                                        remain = tail;
                                                        continue;
                                                    }
                                                }
                                            }
                                        }
                                        throw new IllegalStateException("Malformed LS/LE loop");
                                    }
                                    if (!excludeSegs$1.contains((Object)segment)) break block11;
                                    usage2 = usage;
                                    mandatoryUsage$ = Usage.MandatoryUsage$.MODULE$;
                                    if (usage2 != null) break block12;
                                    if (mandatoryUsage$ == null) break block13;
                                    break block14;
                                }
                                if (usage2.equals(mandatoryUsage$)) break block13;
                            }
                            remain = tail;
                            continue;
                        }
                        ReferenceComponent referenceComponent = new ReferenceComponent(segment, (SegmentPosition)position, usage, repeat, ReferenceComponent$.MODULE$.apply$default$5());
                        acc = acc.$colon$colon((Object)referenceComponent);
                        remain = tail;
                        continue;
                    }
                    List comps = this.descend$2(loop, area$1, excludeSegs$1);
                    if (comps.isEmpty()) {
                        remain = tail;
                        continue;
                    }
                    String name = new StringBuilder(0).append(loopId).append(this.groupIdentSuffix()).toString();
                    List subseqs = X12Form$.MODULE$.subsequenceBuilder(comps).buildSubSequences(false, (Option)new Some((Object)name));
                    StructureSequence seq = new StructureSequence(comps, subseqs);
                    GroupComponent groupComponent = new GroupComponent(name, usage, repeat, seq, (Option)None$.MODULE$, GroupComponent$.MODULE$.apply$default$6(), GroupComponent$.MODULE$.apply$default$7());
                    acc = acc.$colon$colon((Object)groupComponent);
                    remain = tail;
                    continue;
                }
                list = Nil$.MODULE$;
                break block9;
            }
            list = acc;
        }
        return list;
    }

    private final List buildComps$1(String area, List infos, scala.collection.immutable.Set excludeSegs$1) {
        return this.buildr$1(infos, (List)Nil$.MODULE$, area, excludeSegs$1);
    }

    private static final Option optSeq$1(Option optlist) {
        None$ none$;
        Option option = optlist;
        if (option instanceof Some) {
            None$ none$2;
            Some some = (Some)option;
            List list = (List)some.value();
            if (list.isEmpty()) {
                none$2 = None$.MODULE$;
            } else {
                List subseqs = X12Form$.MODULE$.subsequenceBuilder(list).buildSubSequences(false, (Option)None$.MODULE$);
                none$2 = new Some((Object)new StructureSequence(list, subseqs));
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private static final int evalExponential$1(long value, long exponent) {
        long result = value * 10L ^ exponent;
        return result > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result;
    }

    private static final int parseExponential$1(int split, String text) {
        int offset = text.charAt(split + 1) == '+' ? split + 2 : split + 1;
        long value = new StringOps(Predef$.MODULE$.augmentString(text.substring(0, split))).toInt();
        long exponent = new StringOps(Predef$.MODULE$.augmentString(text.substring(offset))).toInt();
        return X12TablesConverter$.evalExponential$1(value, exponent);
    }

    public static final /* synthetic */ boolean $anonfun$main$3(String specificVersion$1, File x$27) {
        String string = x$27.getName();
        String string2 = specificVersion$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$main$11(Structure trans$1, Segment seg) {
        return !trans$1.segmentsUsed().contains((Object)seg);
    }

    public static final /* synthetic */ void $anonfun$main$13(EdiSchemaVersion schemaVersion$1, File version$2, File outdir$1, FileWriter listWriter$1, FileWriter versionWriter$1, Structure transact) {
        EdiSchema schema = new EdiSchema(schemaVersion$1, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transact.ident()), (Object)transact)})));
        MODULE$.writeSchema(schema, transact.ident(), (String[])((Object[])new String[]{new StringBuilder(14).append("/x12/").append(version$2.getName()).append("/basedefs").append(MODULE$.yamlExtension()).toString()}), outdir$1);
        listWriter$1.write(new StringBuilder(0).append(transact.ident()).append('\n').toString());
        versionWriter$1.write(new StringBuilder(0).append(transact.ident()).append(' ').toString());
    }

    public static final /* synthetic */ void $anonfun$main$4(File yamldir$1, YamlReader yamlrdr$1, FileWriter versionWriter$1, File version) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Processing ").append(version.getName()).toString());
        Tuple3<scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>>, scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>>, scala.collection.immutable.Map<String, List<Tuple2<String, String>>>> tuple33 = MODULE$.parseFreeform(MODULE$.fileInput(version, MODULE$.freeFormName()));
        if (tuple33 == null) {
            throw new MatchError(tuple33);
        }
        scala.collection.immutable.Map segRules = (scala.collection.immutable.Map)tuple33._1();
        scala.collection.immutable.Map compRules = (scala.collection.immutable.Map)tuple33._2();
        scala.collection.immutable.Map codeSets = (scala.collection.immutable.Map)tuple33._3();
        Tuple3 tuple34 = new Tuple3((Object)segRules, (Object)compRules, (Object)codeSets);
        Tuple3 tuple35 = tuple34;
        scala.collection.immutable.Map segRules2 = (scala.collection.immutable.Map)tuple35._1();
        scala.collection.immutable.Map compRules2 = (scala.collection.immutable.Map)tuple35._2();
        scala.collection.immutable.Map codeSets2 = (scala.collection.immutable.Map)tuple35._3();
        EdiSchemaVersion schemaVersion = new EdiSchemaVersion((EdiForm)X12Form$.MODULE$, version.getName());
        scala.collection.immutable.Map<String, String> elemNames = MODULE$.nameMap(MODULE$.fileInput(version, MODULE$.elementHeadersName()));
        List elemList = (List)((SeqLike)MODULE$.foldInput(MODULE$.fileInput(version, MODULE$.elementDetailsName()), List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, detail) -> {
            List list;
            List list2 = detail;
            if (!(list2 instanceof .colon.colon)) throw new IllegalArgumentException("wrong number of values in file");
            .colon.colon colon2 = (.colon.colon)list2;
            String number = (String)colon2.head();
            List list3 = colon2.tl$access$1();
            if (!(list3 instanceof .colon.colon)) throw new IllegalArgumentException("wrong number of values in file");
            .colon.colon colon3 = (.colon.colon)list3;
            String typ = (String)colon3.head();
            List list4 = colon3.tl$access$1();
            if (!(list4 instanceof .colon.colon)) throw new IllegalArgumentException("wrong number of values in file");
            .colon.colon colon4 = (.colon.colon)list4;
            String min = (String)colon4.head();
            List list5 = colon4.tl$access$1();
            if (!(list5 instanceof .colon.colon)) throw new IllegalArgumentException("wrong number of values in file");
            .colon.colon colon5 = (.colon.colon)list5;
            String max = (String)colon5.head();
            List list6 = colon5.tl$access$1();
            if (!Nil$.MODULE$.equals(list6)) throw new IllegalArgumentException("wrong number of values in file");
            String usetyp = typ.isEmpty() ? "AN" : typ.trim();
            TypeFormat format = X12Constants.buildType((String)usetyp, (int)MODULE$.convertLength(min), (int)MODULE$.convertLength(max));
            if (codeSets2.contains((Object)number)) {
                List cs = (List)codeSets2.get((Object)number).get();
                scala.collection.immutable.Map csmap = (scala.collection.immutable.Map)cs.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(a, b) -> a.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b._1()), (Object)((String)b._2()).replaceAll("[^A-Za-z0-9]", ""))));
                Element element = new Element(number, (String)elemNames.apply((Object)number), format, csmap);
                list = acc.$colon$colon((Object)element);
                return list;
            } else {
                Element element = Element$.MODULE$.apply(number, (String)elemNames.apply((Object)number), format);
                list = acc.$colon$colon((Object)element);
            }
            return list;
        })).sortBy((Function1 & Serializable & scala.Serializable)x$31 -> x$31.ident(), (Ordering)Ordering.String$.MODULE$);
        ListMap elemDefs = (ListMap)elemList.foldLeft((Object)ListMap$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, e) -> acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.ident()), e)));
        if (new File(version, MODULE$.compositeHeadersName()).exists()) {
            scala.collection.immutable.Map<String, String> compNames = MODULE$.nameMap(MODULE$.fileInput(version, MODULE$.compositeHeadersName()));
            List<Tuple2<String, List<List<String>>>> compGroups = MODULE$.gatherGroups(MODULE$.compositeDetailsName(), MODULE$.fileInput(version, MODULE$.compositeDetailsName()), 4, (Option<String>)None$.MODULE$);
            ListMap<String, Composite> compDefs = MODULE$.defineComposites(elemNames, (scala.collection.immutable.Map<String, Element>)elemDefs, compNames, compGroups, (scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>>)compRules2);
            tuple32 = new Tuple3(compNames, compGroups, compDefs);
        } else {
            tuple32 = tuple3 = new Tuple3((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), MODULE$.emptyListOfKeyedLists(), (Object)ListMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        scala.collection.immutable.Map compNames = (scala.collection.immutable.Map)tuple3._1();
        List compGroups = (List)tuple3._2();
        ListMap compDefs = (ListMap)tuple3._3();
        Tuple3 tuple36 = new Tuple3((Object)compNames, (Object)compGroups, (Object)compDefs);
        Tuple3 tuple37 = tuple36;
        scala.collection.immutable.Map compNames2 = (scala.collection.immutable.Map)tuple37._1();
        List compGroups2 = (List)tuple37._2();
        ListMap compDefs2 = (ListMap)tuple37._3();
        scala.collection.immutable.Map<String, String> segNames = MODULE$.nameMap(MODULE$.fileInput(version, MODULE$.segmentHeadersName()));
        List<Tuple2<String, List<List<String>>>> segGroups = MODULE$.gatherGroups(MODULE$.segmentDetailsName(), MODULE$.fileInput(version, MODULE$.segmentDetailsName()), 5, (Option<String>)new Some((Object)"1"));
        ListMap<String, Segment> segDefs = MODULE$.defineSegments(elemNames, (scala.collection.immutable.Map<String, Element>)elemDefs, (scala.collection.immutable.Map<String, String>)compNames2, (scala.collection.immutable.Map<String, Composite>)compDefs2, segNames, (scala.collection.immutable.Map<String, List<X12TablesConverter.SyntaxRule>>)segRules2, segGroups);
        scala.collection.immutable.Map setHeads = MODULE$.foldInput(MODULE$.fileInput(version, MODULE$.transHeadersName()), Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(map, list) -> {
            String group;
            String name;
            String number;
            block3: {
                block2: {
                    List list2 = list;
                    if (!(list2 instanceof .colon.colon)) break block2;
                    .colon.colon colon2 = (.colon.colon)list2;
                    number = (String)colon2.head();
                    List list3 = colon2.tl$access$1();
                    if (!(list3 instanceof .colon.colon)) break block2;
                    .colon.colon colon3 = (.colon.colon)list3;
                    name = (String)colon3.head();
                    List list4 = colon3.tl$access$1();
                    if (!(list4 instanceof .colon.colon)) break block2;
                    .colon.colon colon4 = (.colon.colon)list4;
                    group = (String)colon4.head();
                    List list5 = colon4.tl$access$1();
                    if (Nil$.MODULE$.equals(list5)) break block3;
                }
                throw new IllegalArgumentException("wrong number of values in file");
            }
            scala.collection.immutable.Map map2 = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)number), (Object)new Tuple2((Object)name, (Object)group)));
            return map2;
        });
        List<Tuple2<String, List<List<String>>>> setGroups = MODULE$.gatherGroups(MODULE$.transDetailsName(), MODULE$.fileInput(version, MODULE$.transDetailsName()), 9, (Option<String>)new Some((Object)""));
        String vnum = version.getName();
        EdiSchema baseSchema = new EdiSchema(schemaVersion, (scala.collection.immutable.Map)elemDefs, (scala.collection.immutable.Map)compDefs2, segDefs, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        File outdir = new File(yamldir$1, version.getName());
        outdir.mkdirs();
        MODULE$.writeSchema(baseSchema, "basedefs", (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), outdir);
        MODULE$.verifySchema(baseSchema, "basedefs", outdir, yamlrdr$1);
        scala.collection.immutable.Set binSegs = (scala.collection.immutable.Set)Option$.MODULE$.option2Iterable(segDefs.get((Object)"BIN")).toSet().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(segDefs.get((Object)"BDS")).toSet());
        Seq structures = (Seq)((TraversableOnce)MODULE$.defineStructures((scala.collection.immutable.Map<String, Segment>)segDefs, (scala.collection.immutable.Map<String, Tuple2<String, String>>)setHeads, setGroups, (scala.collection.immutable.Set<Segment>)binSegs, schemaVersion).values().filter((Function1 & Serializable & scala.Serializable)trans -> BoxesRunTime.boxToBoolean((boolean)binSegs.forall((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)X12TablesConverter$.$anonfun$main$11(trans, seg)))))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$33 -> x$33.ident(), (Ordering)Ordering.String$.MODULE$);
        versionWriter$1.write(new StringBuilder(10).append("Version ").append(version.getName()).append(":\n").toString());
        FileWriter listWriter = new FileWriter(new File(outdir, "structures.txt"));
        structures.foreach((Function1 & Serializable & scala.Serializable)transact -> {
            X12TablesConverter$.$anonfun$main$13(schemaVersion, version, outdir, listWriter, versionWriter$1, transact);
            return BoxedUnit.UNIT;
        });
        listWriter.close();
        versionWriter$1.write("\n\n");
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Wrote ").append(structures.size()).append(" transaction sets").toString());
    }

    private X12TablesConverter$() {
        MODULE$ = this;
        this.yamlExtension = ".esl";
        this.codesExtension = ".cs";
        this.transHeadersName = "sethead.txt";
        this.transDetailsName = "setdetl.txt";
        this.segmentHeadersName = "seghead.txt";
        this.segmentDetailsName = "segdetl.txt";
        this.compositeHeadersName = "comhead.txt";
        this.compositeDetailsName = "comdetl.txt";
        this.elementHeadersName = "elehead.txt";
        this.elementDetailsName = "eledetl.txt";
        this.freeFormName = "freeform.txt";
        this.segmentNoteText = "*SEGNTE";
        this.compositeNoteText = "*COMNTE";
        this.codeSetText = "*ELECOD";
        this.groupIdentSuffix = "_Loop";
        this.emptyListOfKeyedLists = Nil$.MODULE$;
    }
}

