/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.CaseFormat;
import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.agent.InvocationContext;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.Metrics;
import com.mulesoft.analytics.collector.config.NodeType;
import com.mulesoft.analytics.collector.config.PipelineRegistry;
import com.mulesoft.analytics.collector.log.LogWriter;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.util.Collection;
import java.util.Collections;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.module.http.internal.request.DefaultHttpRequester;

public class ProcessorNotificationListener
extends AbstractListener
implements MessageProcessorNotificationListener<MessageProcessorNotification> {
    private final Configuration configuration;
    private final String workerHash;
    private final EventPipeline<NotificationEnvelope> metricPipeline;

    public ProcessorNotificationListener(PipelineRegistry pipelineRegistry, LogWriter logWriter, Configuration configuration, String appId) {
        this.configuration = configuration;
        this.workerHash = configuration.generateWorkerHash(appId);
        this.metricPipeline = pipelineRegistry.createPipeline(appId, Metrics.OUTBOUND_INVOCATION, new NotificationTransformer());
    }

    public void onNotification(MessageProcessorNotification notification) {
        String invocationId;
        if (notification.getProcessor() instanceof DefaultHttpRequester) {
            if (notification.getAction() == 1601) {
                ProcessorNotificationListener.incrementOutboundInvocationCounter();
                if (!this.configuration.isHeaderInjectionDisabled() && notification.getSource() != null && notification.getSource().getMessage() != null) {
                    MuleMessage message = notification.getSource().getMessage();
                    message.setProperty("x-anypnt-app-worker", (Object)this.workerHash, PropertyScope.OUTBOUND);
                }
            }
            invocationId = ProcessorNotificationListener.generateOutboundInvocationId(notification.getSource().getMessage().getUniqueId());
        } else {
            invocationId = notification.getSource().getMessage().getMessageRootId() + notification.getProcessorPath();
        }
        NotificationEnvelope envelope = new NotificationEnvelope();
        envelope.notification = notification;
        envelope.invocationId = invocationId;
        this.metricPipeline.submit(new Event<NotificationEnvelope>(envelope));
    }

    private boolean resolveNodeType(MessageProcessorNotification notification, InvocationContext context) {
        String scheme;
        EndpointURI uri;
        MessageProcessor messageProcessor = notification.getProcessor();
        if (messageProcessor == null) {
            return false;
        }
        if (messageProcessor instanceof DefaultHttpRequester) {
            context.setConnector(NodeType.HTTP.getProcessorName());
            return true;
        }
        if (messageProcessor instanceof DefaultOutboundEndpoint && (uri = ((DefaultOutboundEndpoint)messageProcessor).getEndpointURI()) != null && (scheme = uri.getScheme()) != null) {
            context.setConnector(NodeType.OTHER.getProcessorName());
            context.setRemoteHost(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, scheme));
            return true;
        }
        return this.resolveType(context, messageProcessor);
    }

    private class NotificationTransformer
    implements EventMapper<NotificationEnvelope, InvocationContext> {
        private NotificationTransformer() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Collection<Event<InvocationContext>> process(Event<NotificationEnvelope> event) {
            MessageProcessorNotification notification = event.getValue().notification;
            InvocationContext context = new InvocationContext();
            if (notification.getAction() == 1601) {
                context.setAction(InvocationContext.Action.PRE_INVOKE);
            } else {
                if (notification.getAction() != 1602 && notification.getAction() != 1603) return Collections.emptyList();
                String name = ServerNotification.getActionName((int)notification.getAction());
                if (!"message processor post invoke".equals(name)) return Collections.emptyList();
                context.setAction(notification.getExceptionThrown() == null ? InvocationContext.Action.POST_INVOKE_SUCCESS : InvocationContext.Action.POST_INVOKE_ERROR);
            }
            if (!ProcessorNotificationListener.this.resolveNodeType(notification, context)) {
                return Collections.emptyList();
            }
            context.setInvocationId(event.getValue().invocationId);
            context.setFlowName(notification.getResourceIdentifier());
            context.setSourceHash(ProcessorNotificationListener.this.workerHash);
            return Collections.singleton(new Event<long>(notification.getTimestamp(), context));
        }
    }

    private static class NotificationEnvelope {
        MessageProcessorNotification notification;
        String invocationId;

        private NotificationEnvelope() {
        }
    }
}

