/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.Collection;
import java.util.Collections;

public class EnvironmentProvider
implements EventMapper<Fact, Fact> {
    Configuration configuration;
    String appId;
    String orgId;
    String envId;
    String clusterId;
    String runtimeId;
    String serverId;
    DeploymentType deploymentType;

    public EnvironmentProvider(Configuration configuration, String appId) {
        this.appId = appId;
        this.configuration = configuration;
        this.orgId = configuration.getOrgId();
        this.envId = configuration.getEnvId();
        this.clusterId = configuration.getClusterId();
        this.runtimeId = configuration.getRuntimeId();
        this.serverId = configuration.getServerId();
        this.deploymentType = configuration.getDeploymentType();
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact = event.getValue();
        if (this.orgId != null && this.envId != null && this.runtimeId != null) {
            fact.setDimension("deployment_type", this.deploymentType.name());
            fact.setDimension("org_id", this.orgId);
            fact.setDimension("env_id", this.envId);
            fact.setDimension("cluster_id", this.clusterId);
            fact.setDimension("worker_id", this.runtimeId);
            fact.setDimension("app_id", this.appId);
            if (this.serverId != null) {
                fact.setDimension("server_id", this.serverId);
            }
            return Collections.singleton(new Event<long>(event.getTime(), fact));
        }
        return Collections.emptyList();
    }
}

