/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.Step;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncProcessor<T>
extends Step<T, T> {
    private static final Logger LOGGER = LogManager.getLogger(EventPipeline.class);
    private final Event<T> POISON_PILL = new Event<Object>(null, 0L);
    private LinkedBlockingQueue<Event<T>> queue = new LinkedBlockingQueue();
    private int queueMaxSize;

    public AsyncProcessor(int queueMaxSize) {
        this.queueMaxSize = queueMaxSize;
    }

    @Override
    protected void start() {
        Thread thread = new Thread(new AsyncStepEventTask());
        LOGGER.debug("Starting EventReader Thread");
        thread.start();
    }

    @Override
    protected void stop() {
        this.queue.clear();
        if (!this.queue.offer(this.POISON_PILL)) {
            LOGGER.error("LinkedBlockingQueue.offer() unexpectedly returned false");
        }
    }

    @Override
    protected void process(Event<T> event) {
        if (event == null) {
            return;
        }
        while (this.queue.size() >= this.queueMaxSize) {
            this.queue.poll();
            LOGGER.debug("Dropping earliest events since eventBufferQueue has reached max size.");
        }
        if (!this.queue.offer(event)) {
            LOGGER.error("LinkedBlockingQueue.offer() unexpectedly returned false");
        }
    }

    private class AsyncStepEventTask
    implements Runnable {
        private AsyncStepEventTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Event event;
                    while ((event = (Event)AsyncProcessor.this.queue.take()) != AsyncProcessor.this.POISON_PILL) {
                        if (event == null) continue;
                        AsyncProcessor.this.next.process(event);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception inside EventReader thread", (Throwable)e);
                    continue;
                }
                break;
            }
            LOGGER.debug("Exiting EventReader Thread");
        }
    }
}

