/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.Yaml;

public class MuleAgentConfig {
    private static final String KEY_STORE_PASSWORD = "keyStorePassword";
    private static final String ENDPOINT = "endpoint";
    private static final String GLOBAL_CONFIGURATION = "globalConfiguration";
    private static final String SECURITY = "security";
    private static final String AUTHENTICATION_PROXY = "authenticationProxy";
    private static final String PROXY_CONFIGURATION = "proxyConfiguration";
    private static final String PROXY_HOST = "host";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USER = "user";
    private static final String PROXY_PASSWORD = "password";
    private HashMap<Object, Object> root;

    public MuleAgentConfig(String content) {
        Yaml yaml = new Yaml();
        this.root = (HashMap)yaml.load(content);
    }

    private Optional<Map> getSecurity() {
        return this.getCG().map(m -> (Map)m.get(SECURITY));
    }

    private Optional<Map> getCG() {
        return Optional.ofNullable((Map)this.root.get(GLOBAL_CONFIGURATION));
    }

    private Optional<Map> getAuthenticationProxy() {
        return this.getCG().map(m -> (Map)m.get(AUTHENTICATION_PROXY));
    }

    public Optional<String> getAuthenticationProxyEndpoint() {
        Optional<Map> authenticationProxy = this.getAuthenticationProxy();
        return authenticationProxy.map(ap -> (String)ap.get(ENDPOINT));
    }

    public Optional<String> getKeyStorePassword() {
        Optional<Map> security = this.getSecurity();
        return security.map(ap -> (String)ap.get(KEY_STORE_PASSWORD));
    }

    private Optional<Map> getProxyConfiguration() {
        return this.getCG().map(m -> (Map)m.get(PROXY_CONFIGURATION));
    }

    public Optional<String> getProxyHost() {
        Optional<Map> security = this.getProxyConfiguration();
        return security.map(ap -> (String)ap.get(PROXY_HOST));
    }

    public Optional<Integer> getProxyPort() {
        Optional<Map> security = this.getProxyConfiguration();
        return security.map(ap -> (Integer)ap.get(PROXY_PORT));
    }

    public Optional<String> getProxyUser() {
        Optional<Map> security = this.getProxyConfiguration();
        return security.map(ap -> (String)ap.get(PROXY_USER));
    }

    public Optional<String> getProxyPassword() {
        Optional<Map> security = this.getProxyConfiguration();
        return security.map(ap -> (String)ap.get(PROXY_PASSWORD));
    }
}

