/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent.version;

import com.mulesoft.dias.util.MuleHomePath;
import com.mulesoft.dias.util.Version;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;

public enum MuleAgentVersion {
    MULE_3(MuleHomePath.getMule3AgentPluginPath(""), MuleHomePath.getMule3AgentPluginPath("modules"), "analytics-metrics-collector-mule3-(\\d+\\.)?(\\d+\\.)?(\\*|\\d+).jar"){

        @Override
        public boolean supports(Version v) {
            return v.getMayor() == 3;
        }
    }
    ,
    MULE_4(MuleHomePath.getMule4gentPluginPath(), MuleHomePath.getMule4gentPluginPath(), "analytics-metrics-collector-mule4-(\\d+\\.)?(\\d+\\.)?(\\*|\\d+).jar"){

        @Override
        public boolean supports(Version v) {
            return v.getMayor() == 4;
        }
    };

    private final Path agentPluginPath;
    private final Path unifiedAgentPath;
    private final String unifiedAgentNamePattern;

    private MuleAgentVersion(Path agentPluginPath, Path unifiedAgentPath, String unifiedAgentNamePattern) {
        this.agentPluginPath = agentPluginPath;
        this.unifiedAgentPath = unifiedAgentPath;
        this.unifiedAgentNamePattern = unifiedAgentNamePattern;
    }

    abstract boolean supports(Version var1);

    public String getUnifiedAgentNamePattern() {
        return this.unifiedAgentNamePattern;
    }

    public Path getAgentPluginPath() {
        return this.agentPluginPath;
    }

    public Path getUnifiedAgentPath() {
        return this.unifiedAgentPath;
    }

    public File getAgentAMFile() {
        File libDirectory = MuleHomePath.getAMLibPath("").toFile();
        return (File)Arrays.stream((Object[])Objects.requireNonNull(libDirectory.listFiles((dir, name) -> name.matches(this.getUnifiedAgentNamePattern())))).findFirst().orElseThrow(() -> new IllegalArgumentException("Agent file not found"));
    }

    public Path getLibTarget() {
        return Paths.get(this.getUnifiedAgentPath().toString(), this.getAgentAMFile().getName());
    }

    public static MuleAgentVersion detect(Version versionStr) {
        return Arrays.stream(MuleAgentVersion.values()).filter(a -> a.supports(versionStr)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No am agent support for Mule version '%s'", versionStr)));
    }
}

