/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.config.model.RuntimeConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class Configuration {
    public static final String PROPERTY_FLAG_ENABLE_AGENT = "anypoint.platform.config.analytics.agent.enabled";
    public static final String PROPERTY_FLAG_DISABLE_AGENT = "anypoint.platform.config.analytics.agent.disabled";
    public static final String VISUALIZER_PROPERTY_NAMESPACE = "anypoint.platform.visualizer.";
    public static final String PROPERTY_FLAG_DISABLE_HEADER_INJECTION = "anypoint.platform.config.analytics.agent.header_injection.disabled";
    public static final String HTTP_APP_WORKER_HEADER = "x-anypnt-app-worker";
    public static final String RTF_APP_NAME_ENV_VAR = "MULE_APP_NAME";
    public static final String RTF_NODE_NAME_ENV_VAR = "NODE_NAME";
    public static final String RTF_POD_NAME_ENV_VAR = "POD_NAME";
    public static final String RTF_RTF_ID_ENV_VAR = "RTF_ID";
    public static final String RTF_ORG_ID_ENV_VAR = "ORG_ID";
    public static final String RTF_MASTER_ORG_ID_ENV_VAR = "MASTER_ORG_ID";
    public static final String RTF_ENV_ID_ENV_VAR = "ENV_ID";
    private static final Logger LOGGER = LogManager.getLogger(Configuration.class);
    private static final String WORKER_PREFIX = "worker-";
    private final Path MULE_HOME = Paths.get("" + System.getProperty("mule.home"), new String[0]);
    private final Path MULE_LOGS_PATH = this.MULE_HOME.resolve("logs");
    private final Path FILEBEAT_CONFIG_PATH = this.MULE_HOME.resolve("am").resolve("config");
    private final Path SERVER_ID_FILE = this.FILEBEAT_CONFIG_PATH.resolve("server.id");
    private final Path PROXY_URL_FILE = this.FILEBEAT_CONFIG_PATH.resolve("proxy.url");
    private boolean isRunning = false;
    private DeploymentType deploymentType = null;
    private RuntimeConfig runtimeConfig = null;
    private String orgId;
    private String masterOrgId;
    private String envId;
    private String envType;
    private String runtimeId;
    private String clusterId;
    private String serverName;
    private String appId;
    private String proxyUrl;
    private boolean isServerIdSet = false;
    private String serverId;
    private boolean isPublicIPSet = false;
    private String publicIP;
    private boolean isDeploymentHashSet = false;
    private String deploymentHash;
    private String metricFileName;
    private String metricFilePattern;
    private String metricFileSize;
    private String metricMaxFiles;
    private Boolean disableHeaderInjection;
    private int muleMajorVersion = 3;
    private Map<String, Properties> appSpecificProperties = new HashMap<String, Properties>();

    public DeploymentType getDeploymentType() {
        this.getOrgId();
        return this.deploymentType;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void setAppSpecificProperties(String appName, Properties properties) {
        if (properties != null) {
            this.appSpecificProperties.put(appName, properties);
        } else {
            this.appSpecificProperties.remove(appName);
        }
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public String getOrgId() {
        if (this.orgId == null) {
            this.orgId = System.getProperty("csorganization.id");
            if (this.orgId != null) {
                this.deploymentType = DeploymentType.CLOUDHUB;
            } else {
                this.orgId = System.getProperty("organization.id");
                if (this.orgId == null && this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getOrgId() != null) {
                    this.orgId = this.runtimeConfig.getId().getOrgId();
                }
                if (this.orgId != null) {
                    this.deploymentType = DeploymentType.HYBRID;
                }
                if (this.orgId == null) {
                    this.orgId = System.getenv(RTF_ORG_ID_ENV_VAR);
                    if (this.orgId != null) {
                        this.deploymentType = DeploymentType.RTF;
                    }
                }
            }
        }
        return this.orgId;
    }

    public String getMasterOrgId() {
        if (this.masterOrgId == null) {
            this.masterOrgId = System.getProperty("master.organization.id");
            if (this.masterOrgId == null && this.masterOrgId == null && this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getMasterOrgId() != null) {
                this.masterOrgId = this.runtimeConfig.getId().getMasterOrgId();
            }
            if (this.masterOrgId == null) {
                this.masterOrgId = System.getenv(RTF_MASTER_ORG_ID_ENV_VAR);
            }
        }
        return this.masterOrgId;
    }

    public String getEnvId() {
        if (this.envId == null) {
            this.envId = System.getProperty("environment.id");
            if (this.envId == null && this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getEnvId() != null) {
                this.envId = this.runtimeConfig.getId().getEnvId();
            }
            if (this.envId == null) {
                this.envId = System.getenv(RTF_ENV_ID_ENV_VAR);
            }
        }
        return this.envId;
    }

    public String getEnvType() {
        if (this.envType == null) {
            this.envType = System.getProperty("environment.type");
            if (this.envType == null && this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getEnvType() != null) {
                this.envType = this.runtimeConfig.getId().getEnvType();
            }
        }
        return this.envType;
    }

    public String getRuntimeId() {
        if (this.runtimeId == null) {
            String workerId;
            String rtId;
            String serverName = System.getProperty("server.id");
            this.runtimeId = serverName != null ? serverName : ((rtId = System.getProperty("runtime.id")) != null ? rtId : ((workerId = System.getProperty("worker.id")) != null ? WORKER_PREFIX + workerId : (this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getRuntimeId() != null && !this.runtimeConfig.getId().getRuntimeId().isEmpty() ? this.runtimeConfig.getId().getRuntimeId() : Configuration.readFirstLine(this.SERVER_ID_FILE))));
            if (this.runtimeId == null) {
                this.runtimeId = System.getenv(RTF_POD_NAME_ENV_VAR);
            }
        }
        return this.runtimeId;
    }

    public String getProxyUrl() {
        if (this.proxyUrl == null) {
            this.proxyUrl = Configuration.readFirstLine(this.PROXY_URL_FILE);
        }
        return this.proxyUrl;
    }

    public String getServerName() {
        if (this.serverName == null) {
            String name = System.getProperty("server.name");
            if (name != null) {
                this.serverName = name;
            } else if (this.serverName == null && this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getServerName() != null) {
                this.serverName = this.runtimeConfig.getId().getServerName();
            }
        }
        return this.serverName;
    }

    public String getClusterId() {
        if (this.clusterId == null) {
            String id = System.getProperty("cluster.id");
            if (id != null) {
                this.clusterId = id;
            } else if (this.clusterId == null && this.runtimeConfig != null && this.runtimeConfig.getId() != null && this.runtimeConfig.getId().getClusterId() != null) {
                this.clusterId = this.runtimeConfig.getId().getClusterId();
            } else {
                this.clusterId = System.getenv(RTF_RTF_ID_ENV_VAR);
                if (this.clusterId == null) {
                    String val = System.getProperty("application.id");
                    this.clusterId = val != null ? val : this.getRuntimeId();
                }
            }
        }
        return this.clusterId;
    }

    public String getServerId() {
        if (!this.isServerIdSet) {
            this.isServerIdSet = true;
            this.serverId = System.getenv(RTF_NODE_NAME_ENV_VAR);
        }
        return this.serverId;
    }

    public String getPublicIP() {
        if (!this.isPublicIPSet) {
            this.isPublicIPSet = true;
            this.publicIP = System.getProperty("worker.publicIP");
        }
        return this.publicIP;
    }

    public String overrideAppId(String originalAppId) {
        if (this.appId != null) {
            return this.appId;
        }
        this.appId = System.getProperty("fullDomain");
        if (this.appId == null) {
            this.appId = System.getenv(RTF_APP_NAME_ENV_VAR);
        }
        return this.appId != null ? this.appId : originalAppId;
    }

    public boolean isDisabled() {
        String enabled = System.getProperty(PROPERTY_FLAG_ENABLE_AGENT);
        String disabled = System.getProperty(PROPERTY_FLAG_DISABLE_AGENT);
        if (enabled == null && disabled == null && this.getDeploymentType() == DeploymentType.CLOUDHUB) {
            return true;
        }
        if (enabled != null && !"true".equalsIgnoreCase(enabled) || disabled != null && "true".equalsIgnoreCase(disabled)) {
            return true;
        }
        return this.getOrgId() == null || this.getEnvId() == null || this.getRuntimeId() == null;
    }

    public int getPrebufferMaxSize() {
        if (this.runtimeConfig != null && this.runtimeConfig.getPrebufferMaxSize() != null) {
            return this.runtimeConfig.getPrebufferMaxSize();
        }
        return 10000;
    }

    public int getCombinerMaxSize() {
        if (this.runtimeConfig != null && this.runtimeConfig.getCombinerMaxSize() != null) {
            return this.runtimeConfig.getCombinerMaxSize();
        }
        return 1000;
    }

    public int getAggregationTimeInterval() {
        if (this.runtimeConfig != null && this.runtimeConfig.getAggregationTimeInterval() != null) {
            return this.runtimeConfig.getAggregationTimeInterval();
        }
        return 60000;
    }

    public int getAggregationTopN() {
        if (this.runtimeConfig != null && this.runtimeConfig.getAggregationTopN() != null) {
            return this.runtimeConfig.getAggregationTopN();
        }
        return 100;
    }

    public String getOtherValue() {
        if (this.runtimeConfig != null && this.runtimeConfig.getOtherValue() != null) {
            return this.runtimeConfig.getOtherValue();
        }
        return "other";
    }

    public Map<String, String> getVisualizerProperties(String appName) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.extractProperties(this.appSpecificProperties.get(appName), result);
        this.extractProperties(System.getProperties(), result);
        return result;
    }

    private void extractProperties(Properties props, Map<String, String> result) {
        if (props != null) {
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                if (!propertyName.startsWith(VISUALIZER_PROPERTY_NAMESPACE) || propertyName.split(VISUALIZER_PROPERTY_NAMESPACE).length != 2) continue;
                result.put("viz." + propertyName.split(VISUALIZER_PROPERTY_NAMESPACE)[1].toLowerCase(), props.getProperty(propertyName));
            }
        }
    }

    public String generateWorkerHash(String appId) {
        appId = this.overrideAppId(appId);
        return this.generateHash(this.getOrgId(), this.getEnvId(), this.getRuntimeId(), appId);
    }

    private String generateHash(String ... elementsToHash) {
        try {
            MessageDigest instance = MessageDigest.getInstance("MD5");
            for (String str : elementsToHash) {
                instance.update(str.getBytes());
            }
            return DatatypeConverter.printHexBinary((byte[])instance.digest());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to produce a hash", (Throwable)e);
            return null;
        }
    }

    public String getDeploymentHash() {
        if (!this.isDeploymentHashSet) {
            this.isDeploymentHashSet = true;
            String appId = System.getProperty("application.id");
            String fileDigest = System.getProperty("application.file.content.digest");
            String propsDigest = System.getProperty("application.runtime.properties.digest");
            if (appId != null && fileDigest != null && propsDigest != null) {
                this.deploymentHash = this.generateHash(appId, fileDigest, propsDigest);
            }
        }
        return this.deploymentHash;
    }

    public Path getAmConfigPath() {
        return this.FILEBEAT_CONFIG_PATH;
    }

    public Path getMuleLogsPath() {
        return this.MULE_LOGS_PATH;
    }

    public Path getMuleHome() {
        return this.MULE_HOME;
    }

    public String getMetricLogFileName() {
        if (this.metricFileName == null) {
            if (this.runtimeConfig != null && this.runtimeConfig.getMetricLog() != null && this.runtimeConfig.getMetricLog().getFileName() != null) {
                Path path = this.getMuleLogsPath().resolve(this.runtimeConfig.getMetricLog().getFileName()).normalize();
                if (path.startsWith(this.getMuleLogsPath())) {
                    this.metricFileName = path.toString();
                } else {
                    LOGGER.warn("Illegal metric file name: " + this.runtimeConfig.getMetricLog().getFileName());
                }
            }
            if (this.metricFileName == null) {
                this.metricFileName = this.getMuleLogsPath().resolve("_metric.log").toString();
            }
        }
        return this.metricFileName;
    }

    public String getMetricLogFilePattern() {
        if (this.metricFilePattern == null) {
            if (this.runtimeConfig != null && this.runtimeConfig.getMetricLog() != null && this.runtimeConfig.getMetricLog().getFilePattern() != null) {
                Path path = this.getMuleLogsPath().resolve(this.runtimeConfig.getMetricLog().getFilePattern()).normalize();
                if (path.startsWith(this.getMuleLogsPath())) {
                    this.metricFilePattern = path.toString();
                } else {
                    LOGGER.warn("Illegal metric file pattern: " + this.runtimeConfig.getMetricLog().getFilePattern());
                }
            }
            if (this.metricFilePattern == null) {
                this.metricFilePattern = this.getMuleLogsPath().resolve("_metric-%i.log").toString();
            }
        }
        return this.metricFilePattern;
    }

    public String getMetricLogFileSize() {
        if (this.metricFileSize == null) {
            this.metricFileSize = this.runtimeConfig != null && this.runtimeConfig.getMetricLog() != null && this.runtimeConfig.getMetricLog().getFileSize() != null ? this.runtimeConfig.getMetricLog().getFileSize() : "10 MB";
        }
        return this.metricFileSize;
    }

    public String getMetricLogMaxFiles() {
        if (this.metricMaxFiles == null) {
            this.metricMaxFiles = this.runtimeConfig != null && this.runtimeConfig.getMetricLog() != null && this.runtimeConfig.getMetricLog().getMaxFiles() != null ? this.runtimeConfig.getMetricLog().getMaxFiles() : "10";
        }
        return this.metricMaxFiles;
    }

    public boolean isHeaderInjectionDisabled() {
        if (this.disableHeaderInjection == null) {
            if (this.getMuleMajorVersion() == 4 && this.getDeploymentType() == DeploymentType.CLOUDHUB) {
                this.disableHeaderInjection = true;
            } else {
                String val = System.getProperty(PROPERTY_FLAG_DISABLE_HEADER_INJECTION);
                this.disableHeaderInjection = this.getMuleMajorVersion() == 4 && val == null && this.getDeploymentType() == DeploymentType.HYBRID ? Boolean.valueOf(true) : Boolean.valueOf("true".equalsIgnoreCase(val));
            }
        }
        return this.disableHeaderInjection;
    }

    public void logConfiguration() {
        LOGGER.info("Mode: {}", (Object)this.getDeploymentType());
        LOGGER.info("Prebuffer max size: {}", (Object)this.getPrebufferMaxSize());
        LOGGER.info("Combiner max size: {}", (Object)this.getCombinerMaxSize());
        LOGGER.info("Aggregation time interval: {} ms", (Object)this.getAggregationTimeInterval());
        LOGGER.info("Aggregation Top N: {}", (Object)this.getAggregationTopN());
        LOGGER.info("Metric log file name: {}", (Object)this.getMetricLogFileName());
        LOGGER.info("Metric log file pattern: {}", (Object)this.getMetricLogFilePattern());
        LOGGER.info("Metric log file max size: {}", (Object)this.getMetricLogFileSize());
        LOGGER.info("Metric log max file number: {}", (Object)this.getMetricLogMaxFiles());
        LOGGER.info("Header Injection Enabled: {}", (Object)(!this.isHeaderInjectionDisabled() ? 1 : 0));
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    private static String readFirstLine(Path path) {
        if (path.toFile().exists()) {
            try {
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                if (!lines.isEmpty()) {
                    return lines.get(0);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read file: " + path, (Throwable)e);
            }
        }
        return null;
    }

    public int getMuleMajorVersion() {
        return this.muleMajorVersion;
    }

    public void setMuleMajorVersion(int muleMajorVersion) {
        this.muleMajorVersion = muleMajorVersion;
    }
}

