/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.configurator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.service.AuthenticationProxyClient;
import com.mulesoft.dias.service.DefaultAuthenticationProxyFactory;
import com.mulesoft.dias.service.ProxyServerFactory;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.InstallerMessages;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.util.Optional;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;

public class AgentConfigurator {
    private static final String PROVISIONING_CONFIG_REGISTER = "/dias/provisioning/register/api/v1";

    public void pushConfiguration() {
        try {
            String agentConfig = new String(Files.readAllBytes(MuleHomePath.getConfigPath("mule-agent.yml")));
            MuleAgentConfig muleAgent = new MuleAgentConfig(agentConfig);
            Optional<String> keyStorePassword = muleAgent.getKeyStorePassword();
            Optional<String> authenticationProxyEndpoint = muleAgent.getAuthenticationProxyEndpoint();
            if (!keyStorePassword.isPresent() || !authenticationProxyEndpoint.isPresent()) {
                ConsoleLogger.error(InstallerMessages.agentConfigPropertyMissing());
                System.exit(-1);
            }
            String authProxyEndpoint = authenticationProxyEndpoint.get();
            DefaultAuthenticationProxyFactory defaultAuthenticationProxyFactory = new DefaultAuthenticationProxyFactory();
            URI uri = new URI(authProxyEndpoint);
            AuthenticationProxyClient authenticationProxyClient = defaultAuthenticationProxyFactory.create(keyStorePassword.get(), new ObjectMapper(), uri);
            Response response = this.pushConfigurationToArm(muleAgent, authenticationProxyClient);
            AgentConfigurator.validatePushConfigurationResponse(response);
            authenticationProxyClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Response pushConfigurationToArm(MuleAgentConfig muleAgent, AuthenticationProxyClient authenticationProxyClient) {
        Optional<String> proxyHost = muleAgent.getProxyHost();
        Optional<Integer> proxyPort = muleAgent.getProxyPort();
        if (!proxyHost.isPresent() && !proxyPort.isPresent()) {
            return authenticationProxyClient.post(PROVISIONING_CONFIG_REGISTER);
        }
        if (!proxyHost.isPresent() || !proxyPort.isPresent()) {
            ConsoleLogger.error(InstallerMessages.proxyConfigMissing());
            System.exit(-1);
        }
        ProxyServer.Builder proxyBuilder = new ProxyServerFactory().create(proxyHost.get(), proxyPort.get(), muleAgent.getProxyUser().orElse(""), muleAgent.getProxyPassword().orElse(""));
        return authenticationProxyClient.post(PROVISIONING_CONFIG_REGISTER, proxyBuilder.build());
    }

    private static void validatePushConfigurationResponse(Response response) throws IOException {
        int responseCode = response.getStatusCode();
        if (responseCode == 200) {
            ConsoleLogger.info(InstallerMessages.agentConfigSuccessfully());
        } else if (responseCode == 401) {
            ConsoleLogger.error(InstallerMessages.unauthorized());
        } else {
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed request with code ").append(responseCode).append(".");
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getResponseBodyAsStream()));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            ConsoleLogger.error(stringBuilder.toString());
        }
    }
}

