/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.analytics.collector.agent.JMXMetricHandler;
import com.mulesoft.analytics.collector.agent.MetricProvider;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Tuple;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JMXOperatingSystemMetricProvider
implements MetricProvider {
    private static final Logger LOGGER = LogManager.getLogger(JMXMetricHandler.class);
    private static final String MEASURE = "operatingsystem";
    static final Map<String, String> OS_METRICS = ImmutableMap.builder().put((Object)"AvailableProcessors", (Object)"available_processors").put((Object)"SystemLoadAverage", (Object)"system_load_average").put((Object)"CommittedVirtualMemorySize", (Object)"commited_virtual_memory_size").put((Object)"TotalSwapSpaceSize", (Object)"total_swap_space_size").put((Object)"FreeSwapSpaceSize", (Object)"free_swap_space_size").put((Object)"ProcessCpuTime", (Object)"process_cpu_time").put((Object)"FreePhysicalMemorySize", (Object)"free_physical_memory_size").put((Object)"TotalPhysicalMemorySize", (Object)"total_physical_memory_size").put((Object)"SystemCpuLoad", (Object)"system_cpu_load").put((Object)"ProcessCpuLoad", (Object)"process_cpu_load").build();
    private volatile boolean enabled = true;

    @Override
    public Collection<MetricRecord> getMetrics(List<Tuple<String, String>> tags) {
        ArrayList<MetricRecord> metrics = new ArrayList<MetricRecord>();
        if (this.enabled) {
            try {
                ObjectName operatingSystem = new ObjectName("java.lang", "type", "OperatingSystem");
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                for (Map.Entry<String, String> attributeName : OS_METRICS.entrySet()) {
                    try {
                        Object attribute = mBeanServer.getAttribute(operatingSystem, attributeName.getKey());
                        if (null == attribute || !(attribute instanceof Number)) continue;
                        Tuple<String, String> tuple = Tuple.tuple(attributeName.getValue(), attribute.toString());
                        metrics.add(MetricRecord.create(MEASURE, tags, Collections.singletonList(tuple)));
                    }
                    catch (AttributeNotFoundException e) {
                        LOGGER.debug("Attribute not found in OperatingSystem MBean: " + attributeName.getKey());
                    }
                }
                if (metrics.size() == 0) {
                    this.enabled = false;
                }
            }
            catch (MalformedObjectNameException e) {
                LOGGER.error("Invalid object name for OperatingSystem Mbean", (Throwable)e);
                this.enabled = false;
            }
            catch (InstanceNotFoundException e) {
                LOGGER.error("Instance not found for OperatingSystem Mbean", (Throwable)e);
                this.enabled = false;
            }
            catch (ReflectionException e) {
                LOGGER.error("Invalid reference for OperatingSystem Mbean", (Throwable)e);
                this.enabled = false;
            }
            catch (MBeanException e) {
                this.enabled = false;
                LOGGER.error("JMX error on access OperatingSystem Mbean", (Throwable)e);
            }
        }
        return metrics;
    }
}

