/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import java.util.ArrayList;
import java.util.Collection;

public class FactMeta {
    private String name;
    private Collection<String> retainingDimensions;
    private Collection<String> collapsibleDimensions;
    private Collection<String> longMetrics;
    private Collection<String> doubleMetrics;

    private FactMeta(String name, Collection<String> retainingDimensions, Collection<String> collapsibleDimensions, Collection<String> longMetrics, Collection<String> doubleMetrics) {
        this.name = name;
        this.retainingDimensions = retainingDimensions;
        this.collapsibleDimensions = collapsibleDimensions;
        this.longMetrics = longMetrics;
        this.doubleMetrics = doubleMetrics;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getRetainingDimensions() {
        return this.retainingDimensions;
    }

    public Collection<String> getCollapsibleDimensions() {
        return this.collapsibleDimensions;
    }

    public Collection<String> getLongMetrics() {
        return this.longMetrics;
    }

    public Collection<String> getDoubleMetrics() {
        return this.doubleMetrics;
    }

    public static class Builder {
        private String name;
        private Collection<String> retainingDimensions = new ArrayList<String>();
        private Collection<String> collapsibleDimensions = new ArrayList<String>();
        private Collection<String> longMetrics = new ArrayList<String>();
        private Collection<String> doubleMetrics = new ArrayList<String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder addRetainingDimension(String name) {
            this.retainingDimensions.add(name);
            return this;
        }

        public Builder addCollapsibleDimension(String name) {
            this.collapsibleDimensions.add(name);
            return this;
        }

        public Builder addLongMetric(String name) {
            this.longMetrics.add(name);
            return this;
        }

        public Builder addDoubleMetric(String name) {
            this.doubleMetrics.add(name);
            return this;
        }

        public FactMeta build() {
            return new FactMeta(this.name, this.retainingDimensions, this.collapsibleDimensions, this.longMetrics, this.doubleMetrics);
        }
    }
}

