/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.ScheduledLimiterAndAggregator;
import java.util.Collection;
import java.util.Collections;

public class LongAverageCalculator
implements EventMapper<Fact, Fact> {
    String inputBaseMetric;
    String outputAverageMetric;

    public LongAverageCalculator(String inputBaseMetric, String outputAverageMetric) {
        this.inputBaseMetric = inputBaseMetric;
        this.outputAverageMetric = outputAverageMetric;
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact = event.getValue();
        Long count = fact.getLongMetric(ScheduledLimiterAndAggregator.toCountMetric(this.inputBaseMetric));
        Long sum = fact.getLongMetric(ScheduledLimiterAndAggregator.toSumMetric(this.inputBaseMetric));
        if (count != null && sum != null) {
            fact.setLongMetric(this.outputAverageMetric, sum / count);
        }
        return Collections.singleton(event);
    }
}

