/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.data;

import com.mulesoft.analytics.limiter.NamePath;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class StringNamePath
implements NamePath,
Serializable {
    private static final long serialVersionUID = 7249584373643060281L;
    private final String[] path;
    private final int hashCode;
    private static final char PATH_SEPARATOR = '.';
    public static final Comparator<NamePath> CASE_INSENSITIVE_NAME_PATH_COMPARATOR = new Comparator<NamePath>(){

        @Override
        public int compare(NamePath o1, NamePath o2) {
            String[] rhs;
            if (o1 == o2) {
                return 0;
            }
            String[] lhs = o1.getStringPath();
            if (lhs == (rhs = o2.getStringPath())) {
                return 0;
            }
            if (lhs == null || lhs.length == 0) {
                return -1;
            }
            if (rhs == null || rhs.length == 0) {
                return 1;
            }
            int maxLength = Math.min(lhs.length, rhs.length);
            for (int i = 0; i < maxLength; ++i) {
                String lhsString = lhs[i];
                String rhsString = rhs[i];
                if (lhsString == null) {
                    return -1;
                }
                if (rhsString == null) {
                    return 1;
                }
                int result = lhsString.compareToIgnoreCase(rhsString);
                if (result == 0) continue;
                return result;
            }
            return lhs.length == rhs.length ? 0 : (lhs.length < rhs.length ? -1 : 1);
        }
    };

    public StringNamePath(String flatNamePath) {
        this(StringUtils.split((String)flatNamePath, (char)'.'));
    }

    public StringNamePath(String ... namePath) {
        this.path = namePath;
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object[])this.path);
        this.hashCode = builder.hashCode();
    }

    public StringNamePath(Collection<String> namePath) {
        this(namePath.toArray(new String[namePath.size()]));
    }

    public StringNamePath(NamePath other) {
        this((String[])other.getStringPath().clone());
    }

    @Override
    public String[] getStringPath() {
        return this.path;
    }

    public String toString() {
        return StringUtils.join((Object[])this.path, (char)'.');
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StringNamePath other = (StringNamePath)o;
        return Arrays.equals(this.path, other.getStringPath());
    }

    public static final NamePath fromString(String flatNamePath) {
        return new StringNamePath(flatNamePath);
    }
}

