/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.agent.InvocationContext;
import com.mulesoft.analytics.collector.config.Metrics;
import com.mulesoft.analytics.collector.config.NodeType;
import com.mulesoft.analytics.collector.config.PipelineRegistry;
import com.mulesoft.analytics.collector.log.LogWriter;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.ExtensionNotificationListener;

public class HttpExtensionNotificationListener
extends AbstractListener
implements ExtensionNotificationListener {
    protected static final Logger LOGGER = LogManager.getLogger(HttpExtensionNotificationListener.class);
    protected static final String REQUEST_START_ACTION = "REQUEST_START";
    private final EventPipeline<ExtensionNotification> metricPipeline;

    public HttpExtensionNotificationListener(PipelineRegistry pipelineRegistry, LogWriter logWriter, String appId) {
        this.metricPipeline = pipelineRegistry.createPipeline(appId, Metrics.OUTBOUND_INVOCATION, new ExtensionNotificationTransformer());
    }

    public void onNotification(ExtensionNotification notification) {
        this.metricPipeline.submit(new Event<ExtensionNotification>(notification));
    }

    private class ExtensionNotificationTransformer
    implements EventMapper<ExtensionNotification, InvocationContext> {
        private ExtensionNotificationTransformer() {
        }

        @Override
        public Collection<Event<InvocationContext>> process(Event<ExtensionNotification> event) {
            ExtensionNotification notification = event.getValue();
            Component component = notification.getComponent();
            String componentId = HttpExtensionNotificationListener.this.getComponentName(component);
            NodeType type = NodeType.getTypeFromProcessor(componentId);
            if (NodeType.HTTP != type) {
                return Collections.emptyList();
            }
            if (notification.getAction() == null) {
                return Collections.emptyList();
            }
            if (!HttpExtensionNotificationListener.REQUEST_START_ACTION.equals(notification.getAction().getIdentifier())) {
                return Collections.emptyList();
            }
            InvocationContext.Action action = InvocationContext.Action.PRE_INVOKE;
            InvocationContext context = new InvocationContext();
            context.setConnector(type.getProcessorName());
            context.setAction(action);
            context.setInvocationId(HttpExtensionNotificationListener.this.getInvocationId(notification.getEvent(), component));
            if (component != null && component.getLocation() != null) {
                context.setFlowName(component.getLocation().getRootContainerName());
            }
            if (notification.getData() != null && notification.getData().getValue() != null) {
                try {
                    String str = AbstractListener.invokeViaReflection(notification.getData().getValue(), "getUri", String.class);
                    if (str != null) {
                        URI uri = new URI(str);
                        context.setEndpoint(uri.getPath());
                        context.setRemoteHost(uri.getHost());
                        int port = uri.getPort();
                        context.setRemotePort(port >= 0 ? Integer.toString(port) : null);
                        context.setProtocol(uri.getScheme());
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Exception while resolving URI", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            return Collections.singleton(new Event<InvocationContext>(context));
        }
    }
}

