/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.agent.InvocationContext;
import com.mulesoft.analytics.collector.config.TagValues;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.Collection;
import java.util.Collections;

public class InvocationContextToFactTransformer
implements EventMapper<InvocationContext, Fact> {
    private String factName;

    public InvocationContextToFactTransformer(String factName) {
        this.factName = factName;
    }

    @Override
    public Collection<Event<Fact>> process(Event<InvocationContext> event) {
        String sourceHeader;
        String hostHeader;
        InvocationContext.Action action;
        String clientId;
        String operation;
        String protocol;
        String remotePath;
        String remotePort;
        String remoteIp;
        String flowName;
        InvocationContext context = event.getValue();
        Fact result = new Fact(this.factName);
        String connector = context.getConnector();
        if (connector != null) {
            result.setDimension("endpoint_type", connector);
        }
        if ((flowName = context.getFlowName()) != null) {
            result.setDimension("flow_id", flowName);
        }
        if ((remoteIp = context.getRemoteHost()) != null) {
            result.setDimension("remote_host", remoteIp);
        }
        if ((remotePort = context.getRemotePort()) != null) {
            result.setDimension("remote_port", remotePort);
        }
        if ((remotePath = context.getEndpoint()) != null) {
            result.setDimension("endpoint", remotePath);
        }
        if ((protocol = context.getProtocol()) != null) {
            result.setDimension("protocol", protocol);
        }
        if ((operation = context.getOperation()) != null) {
            result.setDimension("operation", operation);
        }
        if ((clientId = context.getClientId()) != null) {
            result.setDimension("client_id", clientId);
        }
        if ((action = context.getAction()) == InvocationContext.Action.POST_INVOKE_SUCCESS || action == InvocationContext.Action.POST_INVOKE_ERROR) {
            result.setDimension("response_type", action == InvocationContext.Action.POST_INVOKE_SUCCESS ? TagValues.OK.name() : TagValues.FAILED.name());
        }
        if ((hostHeader = context.getHostHeader()) != null) {
            result.setDimension("host_header", hostHeader);
        }
        if ((sourceHeader = context.getSourceHash()) != null) {
            result.setDimension("source_hash", sourceHeader);
        }
        return Collections.singleton(new Event<Fact>(event.getTime(), result, context.getInvocationId()));
    }
}

