#!/usr/bin/pwsh

# Start and enable the service on boot
function filebeat_start {
  Write-Host Starting and enabling service filebeat
  Set-Service -Name filebeat -StartupType Automatic
  Start-Service -Name filebeat
}

# Stop and disable the service on boot
function filebeat_stop {
  Write-Host Stopping and disabling service filebeat
  Stop-Service -Name filebeat
  Set-Service -Name filebeat -StartupType Disabled
}

# Restart function - Stops and starts the service
function filebeat_restart {
  Write-Host Restarting service filebeat
  Restart-Service -Name filebeat
}

# Get user input for the action to perform, call the necessary function
$action = $args[0]

switch($action) {
  'start'   { filebeat_start }
  'stop'    { filebeat_stop }
  'restart' { filebeat_restart }
  default   { Write-Host "Usage: .\$($MyInvocation.MyCommand) {start|stop|restart}" }
}
