/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventCollector;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Step;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduledReducer<I, O>
extends Step<I, O> {
    private static final Logger LOGGER = LogManager.getLogger(AsyncProcessor.class);
    protected EventCollector<I, O> collector;
    protected EventProducer<O> optionalPostProducer;
    private long delay;
    private long period;
    private Timer timer;

    protected ScheduledReducer(long delay, long period) {
        this.delay = delay;
        this.period = period;
    }

    protected ScheduledReducer(long period) {
        this(0L, period);
    }

    public ScheduledReducer(long delay, long period, EventCollector<I, O> collector) {
        this(delay, period);
        this.collector = collector;
    }

    public ScheduledReducer(long period, EventCollector<I, O> collector) {
        this(0L, period, collector);
    }

    public ScheduledReducer(long period, EventCollector<I, O> collector, EventProducer<O> additionalProducer) {
        this(period, collector);
        this.optionalPostProducer = additionalProducer;
    }

    public ScheduledReducer<I, O> setPostProducer(EventProducer<O> postProducer) {
        this.optionalPostProducer = postProducer;
        return this;
    }

    @Override
    protected void process(Event<I> event) {
        this.collector.add(event);
    }

    @Override
    protected void start() {
        if (this.timer == null) {
            this.timer = new Timer();
            EventTask eventTask = new EventTask();
            this.timer.scheduleAtFixedRate((TimerTask)eventTask, this.delay, this.period);
        }
    }

    @Override
    protected void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class EventTask
    extends TimerTask {
        private EventTask() {
        }

        @Override
        public void run() {
            try {
                Collection additionalEvents;
                Collection aggregatedEvents = ScheduledReducer.this.collector.collect();
                if (ScheduledReducer.this.optionalPostProducer != null && (additionalEvents = ScheduledReducer.this.optionalPostProducer.produce()) != null) {
                    if (aggregatedEvents == null) {
                        aggregatedEvents = additionalEvents;
                    } else {
                        aggregatedEvents.addAll(additionalEvents);
                    }
                }
                if (aggregatedEvents != null && aggregatedEvents.size() > 0) {
                    for (Event event : aggregatedEvents) {
                        ScheduledReducer.this.next.process(event);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception inside ScheduledAggregationStep thread", (Throwable)e);
            }
        }
    }
}

