/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CustomMetricHandler;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.config.FilebeatConfigurator;
import com.mulesoft.analytics.collector.config.OneTimeThreadExecutor;
import com.mulesoft.analytics.collector.config.PipelineRegistry;
import com.mulesoft.analytics.collector.config.model.RuntimeConfig;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.AbstractDeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.application.Application;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends ConfigurableAgentService
implements DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(CollectorAgentService.class);
    @Configurable(type=Type.DYNAMIC, level=ConfigurationLevel.GLOBAL)
    RuntimeConfig runtimeConfig;
    @Inject
    protected Configuration configuration;
    @Inject
    protected FilebeatConfigurator filebeatConfig;
    @Inject
    protected PipelineRegistry pipelineRegistry;
    @Inject
    private CustomMetricHandler customMetricHandler;
    @Inject
    protected AppStatsHandler appStatsHandler;
    @Inject
    protected MetricLogWriter logWriter;
    @Inject
    protected List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    private DeploymentService deploymentService;
    private DeploymentListener deploymentListener;
    private OneTimeThreadExecutor cloudHubInitializer;
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    protected void doStart() throws MuleException {
        if (this.configuration.getDeploymentType() != DeploymentType.CLOUDHUB) {
            this.internalStart();
        } else {
            this.cloudHubInitializer = new OneTimeThreadExecutor(new Runnable(){

                @Override
                public void run() {
                    CollectorAgentService.this.internalStart();
                }
            });
        }
        if (this.deploymentListener == null) {
            this.deploymentListener = new DeploymentListener();
        }
        this.deploymentService.addDeploymentListener((org.mule.module.launcher.DeploymentListener)this.deploymentListener);
    }

    void internalStart() {
        if (this.configuration.isRunning()) {
            return;
        }
        this.configuration.setMuleMajorVersion(3);
        this.configuration.setRuntimeConfig(this.runtimeConfig);
        if (this.configuration.isDisabled()) {
            LOGGER.info("Not configured or disabled");
            return;
        }
        LOGGER.info("Starting");
        this.configuration.logConfiguration();
        this.logWriter.init(this.configuration);
        if (this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
            this.filebeatConfig.generateFilebeatConfigFile();
            this.filebeatConfig.generateMetricLogConfigFile();
        }
        this.registerListenersForAllApps();
        this.configuration.setRunning(true);
    }

    protected void doStop() throws MuleException {
        if (!this.configuration.isRunning()) {
            return;
        }
        if (!this.configuration.isDisabled()) {
            LOGGER.info("Stopping");
            if (this.deploymentService != null) {
                this.unregisterListenersForAllApps();
                if (this.deploymentListener != null) {
                    this.deploymentService.removeDeploymentListener((org.mule.module.launcher.DeploymentListener)this.deploymentListener);
                }
            }
            this.logWriter.close();
        }
        this.configuration.setRunning(false);
    }

    public void registerListeners(String appId, MuleContext appMuleContext) {
        if (appMuleContext != null) {
            try {
                LOGGER.info("Registering listeners for application {}", (Object)appId);
                appId = this.configuration.overrideAppId(appId);
                ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.pipelineRegistry, this.logWriter, this.configuration, appId);
                this.connectorListeners.put(appId, connectorListener);
                appMuleContext.registerListener((ServerNotificationListener)connectorListener);
                ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.pipelineRegistry, this.logWriter, this.configuration, appId);
                this.processorListeners.put(appId, processorListener);
                appMuleContext.registerListener((ServerNotificationListener)processorListener);
                CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, appId);
                this.customListeners.put(appId, customListener);
                appMuleContext.registerListener((ServerNotificationListener)customListener);
            }
            catch (NotificationException e) {
                LOGGER.error("Could not register listeners for application {}", (Object)appId);
            }
        }
    }

    private void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                this.registerListeners(app.getArtifactName(), app.getMuleContext());
            }
        }
    }

    private void unregisterListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                CustomNotificationListener customListener;
                ConnectorNotificationListener connectorListener;
                String appName = app.getArtifactName();
                MuleContext appMuleContext = app.getMuleContext();
                LOGGER.info("Un-registering listeners for application {}", (Object)appName);
                ProcessorNotificationListener processorListener = this.processorListeners.remove(appName);
                if (processorListener != null) {
                    appMuleContext.unregisterListener((ServerNotificationListener)processorListener);
                }
                if ((connectorListener = this.connectorListeners.remove(appName)) != null) {
                    appMuleContext.unregisterListener((ServerNotificationListener)connectorListener);
                }
                if ((customListener = this.customListeners.remove(appName)) == null) continue;
                appMuleContext.unregisterListener((ServerNotificationListener)customListener);
            }
        }
    }

    private class DeploymentListener
    extends AbstractDeploymentListener {
        private DeploymentListener() {
        }

        public void onMuleContextConfigured(String appName, MuleContext context) {
            if (CollectorAgentService.this.cloudHubInitializer != null) {
                CollectorAgentService.this.cloudHubInitializer.trigger();
            }
            CollectorAgentService.this.filebeatConfig.generateAppLogConfigFile(appName);
            CollectorAgentService.this.registerListeners(appName, context);
            if (CollectorAgentService.this.agentApplicationPropertiesService != null) {
                CollectorAgentService.this.configuration.setAppSpecificProperties(appName, CollectorAgentService.this.agentApplicationPropertiesService.getPropertiesForApplication(appName));
            }
        }

        public void onUndeploymentSuccess(String appName) {
            CollectorAgentService.this.pipelineRegistry.unregister(appName);
            CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
            CollectorAgentService.this.customMetricHandler.unregister(appName);
            CollectorAgentService.this.filebeatConfig.deleteAppLogConfigFile(appName);
            if (CollectorAgentService.this.agentApplicationPropertiesService != null) {
                CollectorAgentService.this.configuration.setAppSpecificProperties(appName, null);
            }
        }
    }
}

