/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.log;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.log.LogWriter;
import javax.inject.Singleton;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Singleton
public class MetricLogWriter
implements LogWriter {
    public static final String LOGGER_NAME = "com.mulesoft.analytics.collector.log.MetricLogger";
    public static final String LINE_PATTERN = "%m%n";
    Logger logger = null;
    LoggerContext context = null;

    @Override
    public void write(String line) {
        if (this.logger != null) {
            this.logger.info(line);
        }
    }

    public void init(Configuration config) {
        String loggerName = LOGGER_NAME;
        String appenderName = "com.mulesoft.analytics.collector.log.MetricLogger__Appender";
        String fileName = config.getMetricLogFileName();
        this.context = new LoggerContext(LOGGER_NAME);
        this.context.start();
        org.apache.logging.log4j.core.config.Configuration ctxConfig = this.context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withPattern(LINE_PATTERN).build();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)config.getMetricLogFileSize());
        CompositeTriggeringPolicy triggeringPolicy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{policy});
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.createStrategy((String)config.getMetricLogMaxFiles(), null, null, null, null, (boolean)false, (org.apache.logging.log4j.core.config.Configuration)ctxConfig);
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)new RollingFileAppender.Builder().withFileName(fileName).withStrategy((RolloverStrategy)strategy).withName("com.mulesoft.analytics.collector.log.MetricLogger__Appender")).withFilePattern(config.getMetricLogFilePattern()).withLayout((Layout)layout)).withPolicy((TriggeringPolicy)triggeringPolicy).build();
        appender.start();
        ctxConfig.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)"com.mulesoft.analytics.collector.log.MetricLogger__Appender", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = AsyncLoggerConfig.createLogger((String)"false", (String)Level.INFO.name(), (String)LOGGER_NAME, (String)"false", (AppenderRef[])refs, null, (org.apache.logging.log4j.core.config.Configuration)ctxConfig, null);
        loggerConfig.addAppender((Appender)appender, Level.INFO, null);
        ctxConfig.addLogger(LOGGER_NAME, loggerConfig);
        this.context.updateLoggers();
        this.logger = this.context.getLogger(LOGGER_NAME);
    }

    public void close() {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
        this.logger = null;
    }
}

