/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.agent.InvocationContext;
import com.mulesoft.analytics.collector.config.NodeType;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class AbstractListener {
    private static final AtomicInteger nextThreadId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> currentThreadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return nextThreadId.getAndIncrement();
        }
    };
    private static final ThreadLocal<Long> outboundInvocationCounter = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    private static final String PROCESSOR_REGEX = "^org\\.mule\\.(module|modules)\\.(.*?)\\.(.*?)(\\.|$)";
    private static final Pattern processorPattern = Pattern.compile("^org\\.mule\\.(module|modules)\\.(.*?)\\.(.*?)(\\.|$)");
    private final Map<Object, String> operationNameCache = Collections.synchronizedMap(new WeakHashMap());

    protected static void incrementOutboundInvocationCounter() {
        outboundInvocationCounter.set(outboundInvocationCounter.get() + 1L);
    }

    protected static String generateOutboundInvocationId(String muleInvocationId) {
        return muleInvocationId + "/" + currentThreadId.get() + "/" + outboundInvocationCounter.get();
    }

    protected static String getOperationName(Object processor) {
        try {
            Object opName = FieldUtils.readField((Object)processor, (String)"operationName", (boolean)true);
            if (null != opName) {
                return opName.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean resolveType(InvocationContext context, Object component) {
        String processorClassName;
        Matcher matcher;
        String operationName;
        if (this.operationNameCache.containsKey(component)) {
            operationName = this.operationNameCache.get(component);
        } else {
            operationName = AbstractListener.getOperationName(component);
            this.operationNameCache.put(component, operationName);
        }
        if (null != operationName) {
            context.setOperation(operationName);
        }
        if ((matcher = processorPattern.matcher(processorClassName = component.getClass().getName())).find() && matcher.group(2) != null) {
            String processor2;
            NodeType nodeType2;
            String processor = matcher.group(2);
            NodeType nodeType = NodeType.getTypeFromProcessor(processor);
            if (NodeType.OTHER == nodeType && matcher.group(3) != null && NodeType.OTHER != (nodeType2 = NodeType.getTypeFromProcessor(processor2 = processor + "." + matcher.group(3)))) {
                processor = processor2;
                nodeType = nodeType2;
            }
            context.setConnector(nodeType.getProcessorName());
            context.setRemoteHost(nodeType.getHostNameFromType(processor));
            return true;
        }
        return false;
    }
}

