/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.domain.monitoring.ApplicationMetrics;
import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHadler;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="mule.agent.analytics.appstats")
@Singleton
public class AppStatsHandler
extends AbstractMessageHadler
implements InternalMessageHandler<GroupedApplicationsMetrics> {
    Map<String, String> appHash = new HashMap<String, String>();
    Map<String, String> workerHash = new HashMap<String, String>();
    Map<String, Map<String, String>> vizProps = new HashMap<String, Map<String, String>>();

    public boolean handle(GroupedApplicationsMetrics message) {
        if (!this.isEnabled() || message == null) {
            return false;
        }
        for (ApplicationMetrics am : message.getMetricsByApplicationName().values()) {
            Map<String, String> vizProps;
            String deploymentHash;
            String appName = this.configuration.overrideAppId(am.getApplicationName());
            List<Tuple<String, String>> tags = this.createBaseTags();
            tags.add(Tuple.tuple("app_id", appName));
            tags.add(Tuple.tuple("deployment_type", this.configuration.getDeploymentType().name()));
            String publicIP = this.configuration.getPublicIP();
            if (publicIP != null) {
                tags.add(Tuple.tuple("public_ip", publicIP));
            }
            if ((deploymentHash = this.configuration.getDeploymentHash()) != null) {
                tags.add(Tuple.tuple("deployment_hash", deploymentHash));
            }
            if ((vizProps = this.getVizProps(appName)) != null) {
                for (Map.Entry<String, String> entry : vizProps.entrySet()) {
                    tags.add(Tuple.tuple(entry.getKey(), entry.getValue()));
                }
            }
            Long timestamp = null;
            ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
            for (Metric metric : am.getMetrics()) {
                String name = metric.getName();
                Number value = metric.getValue();
                values.add(Tuple.tuple(name, value.toString()));
                if (timestamp != null) continue;
                timestamp = metric.getTimestamp();
            }
            if (timestamp == null) continue;
            MetricRecord record = MetricRecord.create("app_stats", tags, values, timestamp);
            if (this.output == null || record == null) continue;
            this.output.write(record.toString());
        }
        return true;
    }

    public synchronized void unregisterApp(String appName) {
        this.appHash.remove(appName);
        this.workerHash.remove(appName);
        this.vizProps.remove(appName);
    }

    private synchronized Map<String, String> getVizProps(String appName) {
        Map<String, String> result = this.vizProps.get(appName);
        if (result == null) {
            result = this.configuration.getVisualizerProperties(appName);
            this.vizProps.put(appName, result);
        }
        return result;
    }
}

