/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventBatchMapper;
import com.mulesoft.analytics.collector.pipeline.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class GroupByKeyReducer<I, O>
extends Step<I, O> {
    protected EventBatchMapper<I, O> processor = null;
    private int maxSize;
    private LinkedHashMap<Object, List<Event<I>>> groupingCache;

    protected GroupByKeyReducer(int cacheMaxSize) {
        this.maxSize = cacheMaxSize;
        this.groupingCache = new LinkedHashMap();
    }

    public GroupByKeyReducer(int maxSize, EventBatchMapper<I, O> processor) {
        this(maxSize);
        this.processor = processor;
    }

    @Override
    protected void process(Event<I> event) {
        if (event == null) {
            return;
        }
        List<Event<I>> events = null;
        Object groupingKey = event.getGroupingKey();
        if (groupingKey != null) {
            events = this.groupingCache.get(groupingKey);
        }
        if (events == null || groupingKey == null) {
            events = new ArrayList<Event<I>>();
        }
        events.add(event);
        Collection<Event<O>> newEvents = this.processor.process(events);
        if (newEvents == null) {
            if (event.getGroupingKey() != null) {
                if (this.groupingCache.size() >= this.maxSize) {
                    Object firstEntry = this.groupingCache.keySet().iterator().next();
                    this.groupingCache.remove(firstEntry);
                }
                this.groupingCache.put(event.getGroupingKey(), events);
            }
        } else if (groupingKey != null) {
            this.groupingCache.remove(groupingKey);
            for (Event<O> newEvent : newEvents) {
                this.next.process(newEvent);
            }
        }
    }
}

