/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.UserEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Fact
implements UserEvent {
    private String name;
    private Map<String, String> dimensions = new HashMap<String, String>();
    private Map<String, Long> longMetrics = new HashMap<String, Long>();
    private Map<String, Double> doubleMetrics = new HashMap<String, Double>();

    public Fact(String name) {
        this.name = name;
    }

    public Fact(String name, Map<String, String> dimensions) {
        this(name);
        this.dimensions = dimensions;
    }

    public Fact(String name, Map<String, String> dimensions, Map<String, Long> longMetrics, Map<String, Double> doubleMetrics) {
        this(name, dimensions);
        this.longMetrics = longMetrics;
        this.doubleMetrics = doubleMetrics;
    }

    public String toString() {
        return "Fact[name=" + this.name + ", dimensions=" + this.dimensions + ", longMetrics=" + this.longMetrics + ", doubleMetrics=" + this.doubleMetrics + "]";
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getDimensions() {
        return this.dimensions.keySet();
    }

    public String getDimension(String name) {
        return this.dimensions.get(name);
    }

    public void setDimension(String name, String value) {
        if (value != null) {
            this.dimensions.put(name, value);
        } else {
            this.dimensions.remove(name);
        }
    }

    public Set<String> getLongMetrics() {
        return this.longMetrics.keySet();
    }

    public Long getLongMetric(String name) {
        return this.longMetrics.get(name);
    }

    public void setLongMetric(String name, Long value) {
        if (value != null) {
            this.longMetrics.put(name, value);
        } else {
            this.longMetrics.remove(name);
        }
    }

    public Set<String> getDoubleMetrics() {
        return this.doubleMetrics.keySet();
    }

    public Double getDoubleMetric(String name) {
        return this.doubleMetrics.get(name);
    }

    public void setDoubleMetric(String name, Double value) {
        if (value != null) {
            this.doubleMetrics.put(name, value);
        } else {
            this.doubleMetrics.remove(name);
        }
    }

    @Override
    public Object getDimensionValue(NamePath dimName) {
        return this.getDimension(dimName.toString());
    }

    @Override
    public Object[] getDimensionValues(NamePath[] dimNames) {
        Object[] result = new Object[dimNames.length];
        for (int i = 0; i < dimNames.length; ++i) {
            result[i] = this.getDimensionValue(dimNames[i]);
        }
        return result;
    }

    @Override
    public long[] getLongMetrics(NamePath[] metricNames) {
        long[] result = new long[metricNames.length];
        for (int i = 0; i < metricNames.length; ++i) {
            result[i] = this.getLongMetric(metricNames[i].toString());
        }
        return result;
    }

    @Override
    public double[] getDoubleMetrics(NamePath[] metricNames) {
        double[] result = new double[metricNames.length];
        for (int i = 0; i < metricNames.length; ++i) {
            result[i] = this.getDoubleMetric(metricNames[i].toString());
        }
        return result;
    }
}

