/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent.unified;

import com.mulesoft.dias.mule.agent.version.MuleAgentVersion;
import com.mulesoft.dias.mule.agent.version.MuleVersion;
import com.mulesoft.dias.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class AgentInstaller {
    public void copyAgentJar() throws IOException {
        MuleAgentVersion muleVersion = MuleVersion.version();
        File muleDirectory = muleVersion.getUnifiedAgentPath().toFile();
        if (!muleDirectory.exists()) {
            FileUtils.createDir(muleDirectory);
        }
        this.deleteOldVersions(muleDirectory);
        this.copyCurrentVersion(muleVersion);
    }

    private void copyCurrentVersion(MuleAgentVersion version) throws IOException {
        Files.copy(version.getAgentAMFile().toPath(), version.getLibTarget(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteOldVersions(File muleDirectory) {
        FileUtils.deleteAgentFiles(muleDirectory, "analytics-metrics-collector-mule.*.jar");
        FileUtils.deleteAgentFiles(muleDirectory, "mule-agent-dias.*.jar");
    }
}

