/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.util.concurrent.Uninterruptibles;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.analytics.collector.agent.CustomMetricHandler;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.config.FilebeatConfigurator;
import com.mulesoft.analytics.collector.config.OneTimeThreadExecutor;
import com.mulesoft.analytics.collector.config.PipelineRegistry;
import com.mulesoft.analytics.collector.config.model.RuntimeConfig;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CollectorAgentBase
implements Switcher {
    protected static final Logger LOGGER = LogManager.getLogger(CollectorAgentBase.class);
    @Configurable(method="isEnabledByDefault")
    protected boolean enabled;
    @Configurable(type=Type.DYNAMIC, level=ConfigurationLevel.GLOBAL)
    protected RuntimeConfig runtimeConfig;
    @Inject
    protected Configuration configuration;
    @Inject
    protected FilebeatConfigurator filebeatConfig;
    @Inject
    protected PipelineRegistry pipelineRegistry;
    @Inject
    protected CustomMetricHandler customMetricHandler;
    @Inject
    protected MetricLogWriter logWriter;
    private OneTimeThreadExecutor delayedInitializer;
    private CountDownLatch delayedInitCompletionLatch = new CountDownLatch(1);

    protected abstract void onCollectorStart();

    protected abstract void onCollectorStop();

    public boolean isEnabledByDefault() {
        return true;
    }

    public void enable(boolean state) {
        this.enabled = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void internalInit(int muleMajorVersion) {
        if (this.configuration.isRunning()) {
            return;
        }
        this.configuration.setMuleMajorVersion(muleMajorVersion);
        this.configuration.setRuntimeConfig(this.runtimeConfig);
        if (!this.configuration.isEnabled()) {
            LOGGER.info("Not configured or disabled");
            return;
        }
        LOGGER.info("Starting");
        this.configuration.logConfiguration();
        this.logWriter.init(this.configuration);
        if (this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
            this.filebeatConfig.generateFilebeatConfigFile();
            this.filebeatConfig.generateMetricLogConfigFile();
        }
        this.onCollectorStart();
        this.configuration.setRunning(true);
    }

    protected void startCollector(final int muleMajorVersion) {
        DeploymentType type = this.configuration.getDeploymentType();
        if (type == DeploymentType.RTF || type == DeploymentType.HYBRID) {
            this.internalInit(muleMajorVersion);
        } else {
            this.delayedInitializer = new OneTimeThreadExecutor(new Runnable(){

                @Override
                public void run() {
                    CollectorAgentBase.this.internalInit(muleMajorVersion);
                    CollectorAgentBase.this.delayedInitCompletionLatch.countDown();
                    if (CollectorAgentBase.this.delayedInitializer != null) {
                        CollectorAgentBase.this.delayedInitializer = null;
                    }
                }
            });
        }
    }

    protected void completeDelayedInitialization() {
        if (this.delayedInitializer != null) {
            this.delayedInitializer.trigger();
            if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.delayedInitCompletionLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS)) {
                LOGGER.warn("Delayed initialization timed out");
            }
        }
    }

    public void stopCollector() {
        if (this.configuration.isRunning() && this.configuration.isEnabled()) {
            LOGGER.info("Stopping");
            this.onCollectorStop();
            this.logWriter.close();
        }
        this.configuration.setRunning(false);
    }
}

