/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.CollectorAgentBase;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.HttpExtensionNotificationListener;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import com.mulesoft.analytics.collector.config.DeploymentType;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends CollectorAgentBase
implements MuleAgentService,
DeploymentServiceAware,
Startable,
Stoppable {
    private static final String POLICY_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:http-policy=\"http://www.mulesoft.org/schema/mule/http-policy\"\n      xmlns:http-transform=\"http://www.mulesoft.org/schema/mule/http-policy-transform\"\nxsi:schemaLocation=\"http://www.mulesoft.org/schema/mule/core\nhttp://www.mulesoft.org/schema/mule/core/current/mule.xsd\nhttp://www.mulesoft.org/schema/mule/http\nhttp://www.mulesoft.org/schema/mule/http/current/mule-http.xsd\nhttp://www.mulesoft.org/schema/mule/http-policy\nhttp://www.mulesoft.org/schema/mule/http-policy/current/mule-http-policy.xsd\nhttp://www.mulesoft.org/schema/mule/os\nhttp://www.mulesoft.org/schema/mule/os/current/mule-os.xsd\">\n\n    <http-policy:proxy name=\"policy-template\">\n        <http-policy:operation>\n           <http-policy:execute-next/>\n        </http-policy:operation>\n    </http-policy:proxy>\n</mule>";
    private static final String POLICY_NAME = "collector-agent-policy";
    @Inject
    private List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    private AppStatsHandler appStatsHandler;
    private DeploymentService deploymentService;
    private DeploymentListener deploymentListener;
    HeaderInjectingPolicyTransformer policyTransformer;
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    private final Map<String, HttpExtensionNotificationListener> extensionListeners = new HashMap<String, HttpExtensionNotificationListener>();
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();

    public void start() {
        this.startCollector(4);
        if (this.deploymentService != null) {
            if (this.deploymentListener == null) {
                this.deploymentListener = new DeploymentListener();
            }
            this.deploymentService.addDeploymentListener((org.mule.runtime.module.deployment.api.DeploymentListener)this.deploymentListener);
        }
    }

    @Override
    protected void onCollectorStart() {
        this.registerListenersForAllApps();
        for (InternalMessageHandler<?> handler : this.messageHandlerList) {
            if (!(handler instanceof AppStatsHandler)) continue;
            this.appStatsHandler = (AppStatsHandler)handler;
            break;
        }
    }

    public void stop() {
        this.stopCollector();
    }

    @Override
    protected void onCollectorStop() {
        this.unregisterListenersForAllApps();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    private void registerListeners(String appId, Registry registry) {
        Optional notificationsListenerRegistry;
        if (registry != null && (notificationsListenerRegistry = registry.lookupByType(NotificationListenerRegistry.class)).isPresent()) {
            try {
                LOGGER.info("Registering listeners for application {}", (Object)appId);
                appId = this.configuration.overrideAppId(appId);
                NotificationListenerRegistry notificationsRegistry = (NotificationListenerRegistry)notificationsListenerRegistry.get();
                ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.pipelineRegistry, this.logWriter, appId);
                this.connectorListeners.put(appId, connectorListener);
                notificationsRegistry.registerListener((NotificationListener)connectorListener);
                ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.pipelineRegistry, this.logWriter, appId);
                this.processorListeners.put(appId, processorListener);
                notificationsRegistry.registerListener((NotificationListener)processorListener);
                HttpExtensionNotificationListener extensionListener = new HttpExtensionNotificationListener(this.pipelineRegistry, this.logWriter, appId);
                this.extensionListeners.put(appId, extensionListener);
                notificationsRegistry.registerListener((NotificationListener)extensionListener);
                CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, appId);
                this.customListeners.put(appId, customListener);
                notificationsRegistry.registerListener((NotificationListener)customListener);
            }
            catch (Exception e) {
                LOGGER.error("Could not register listeners for application {}", (Object)appId);
            }
        }
    }

    private void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                this.registerListeners(app.getArtifactName(), app.getRegistry());
            }
        }
    }

    private void unregisterListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                CustomNotificationListener customListener;
                HttpExtensionNotificationListener extensionListener;
                ConnectorNotificationListener connectorListener;
                Optional notificationsListenerRegistry;
                Registry registry = app.getRegistry();
                if (registry == null || !(notificationsListenerRegistry = registry.lookupByType(NotificationListenerRegistry.class)).isPresent()) continue;
                LOGGER.info("Un-registering listeners for application {}", (Object)app.getArtifactName());
                NotificationListenerRegistry notificationsRegistry = (NotificationListenerRegistry)notificationsListenerRegistry.get();
                String appId = app.getArtifactName();
                appId = this.configuration.overrideAppId(appId);
                ProcessorNotificationListener processorListener = this.processorListeners.remove(appId);
                if (processorListener != null) {
                    notificationsRegistry.unregisterListener((NotificationListener)processorListener);
                }
                if ((connectorListener = this.connectorListeners.remove(appId)) != null) {
                    notificationsRegistry.unregisterListener((NotificationListener)connectorListener);
                }
                if ((extensionListener = this.extensionListeners.remove(appId)) != null) {
                    notificationsRegistry.unregisterListener((NotificationListener)extensionListener);
                }
                if ((customListener = this.customListeners.remove(appId)) == null) continue;
                notificationsRegistry.unregisterListener((NotificationListener)customListener);
            }
            if (this.deploymentListener != null) {
                this.deploymentService.removeDeploymentListener((org.mule.runtime.module.deployment.api.DeploymentListener)this.deploymentListener);
                this.deploymentListener = null;
            }
        }
    }

    private void registerPolicy(String artifactName, Registry registry) {
        block5: {
            artifactName = this.configuration.overrideAppId(artifactName);
            try {
                Optional mc = registry.lookupByName("_muleContext");
                if (!mc.isPresent()) {
                    throw new IllegalStateException("Failed to resolve _muleContext");
                }
                Object obj = mc.get();
                Method m = obj.getClass().getMethod("getExecutionClassLoader", new Class[0]);
                ClassLoader cl = (ClassLoader)m.invoke(obj, new Object[0]);
                Class<?> cls = cl.loadClass("org.mule.extension.http.api.policy.HttpPolicyRequestParametersTransformer");
                OperationPolicyParametersTransformer t = (OperationPolicyParametersTransformer)cls.newInstance();
                this.policyTransformer.init(t, this.configuration.generateWorkerHash(artifactName));
                Optional mpp = registry.lookupByName("_mulePolicyProvider");
                if (mpp.isPresent()) {
                    File policyFile = File.createTempFile(artifactName, "policy.xml");
                    FileUtils.write((File)policyFile, (CharSequence)POLICY_XML);
                    PolicyTemplateDescriptor ptd = new PolicyTemplateDescriptor("collector-agent-policy-template");
                    ptd.setRootFolder(policyFile.getParentFile());
                    ((ApplicationPolicyManager)mpp.get()).removePolicy(POLICY_NAME);
                    ((ApplicationPolicyManager)mpp.get()).addPolicy(ptd, new PolicyParametrization(POLICY_NAME, parameters -> true, 1, new HashMap(), policyFile, new ArrayList()));
                    if (!policyFile.delete()) {
                        LOGGER.warn("Failed to delete temp policy file: " + policyFile);
                    }
                    break block5;
                }
                throw new IllegalStateException("Failed to resolve _mulePolicyProvider");
            }
            catch (Exception e) {
                LOGGER.error("Failed to register http-header-injection policy for app: " + artifactName + ". This will break Anypoint Visualization functionality", (Throwable)e);
            }
        }
    }

    private class DeploymentListener
    implements org.mule.runtime.module.deployment.api.DeploymentListener {
        private DeploymentListener() {
        }

        public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
            CollectorAgentService.this.policyTransformer = new HeaderInjectingPolicyTransformer();
            customizationService.overrideDefaultServiceImpl("http.policy.request.transformer", (Object)CollectorAgentService.this.policyTransformer);
        }

        public void onDeploymentSuccess(String appName) {
            CollectorAgentService.this.completeDelayedInitialization();
            if (CollectorAgentService.this.configuration.isRunning()) {
                Application app;
                if (CollectorAgentService.this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
                    CollectorAgentService.this.filebeatConfig.generateAppLogConfigFile(appName);
                }
                if (CollectorAgentService.this.agentApplicationPropertiesService != null) {
                    CollectorAgentService.this.configuration.addAppSpecificProperties(appName, CollectorAgentService.this.agentApplicationPropertiesService.getPropertiesForApplication(appName));
                }
                if ((app = CollectorAgentService.this.deploymentService.findApplication(appName)) != null) {
                    Registry registry = app.getRegistry();
                    CollectorAgentService.this.registerListeners(appName, registry);
                    if (!CollectorAgentService.this.configuration.isHeaderInjectionDisabled()) {
                        CollectorAgentService.this.registerPolicy(appName, registry);
                    }
                } else {
                    CollectorAgentBase.LOGGER.error("Application not found: " + appName);
                }
            }
        }

        public void onUndeploymentSuccess(String appName) {
            if (CollectorAgentService.this.configuration.isRunning()) {
                CollectorAgentService.this.pipelineRegistry.unregister(appName);
                if (CollectorAgentService.this.appStatsHandler != null) {
                    CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
                }
                CollectorAgentService.this.customMetricHandler.unregister(appName);
                if (CollectorAgentService.this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
                    CollectorAgentService.this.filebeatConfig.deleteAppLogConfigFile(appName);
                }
                if (CollectorAgentService.this.agentApplicationPropertiesService != null) {
                    CollectorAgentService.this.configuration.removeAppSpecificProperties(appName);
                }
            }
        }
    }

    static class HeaderInjectingPolicyTransformer
    implements OperationPolicyParametersTransformer {
        private OperationPolicyParametersTransformer delegate;
        private String workerHash;

        HeaderInjectingPolicyTransformer() {
        }

        void init(OperationPolicyParametersTransformer delegate, String workerHash) {
            this.delegate = delegate;
            this.workerHash = workerHash;
        }

        public boolean supports(ComponentIdentifier componentIdentifier) {
            if (this.delegate != null) {
                return this.delegate.supports(componentIdentifier);
            }
            return false;
        }

        public Message fromParametersToMessage(Map<String, Object> parameters) {
            if (this.delegate != null) {
                return this.delegate.fromParametersToMessage(parameters);
            }
            return null;
        }

        public Map<String, Object> fromMessageToParameters(Message message) {
            if (this.delegate != null) {
                HashMap<String, MultiMap> result = this.delegate.fromMessageToParameters(message);
                if (result != null && this.workerHash != null) {
                    result = new HashMap<String, MultiMap>(result);
                    MultiMap headers = new MultiMap((MultiMap)result.get("headers"));
                    headers.put((Object)"x-anypnt-app-worker", (Object)this.workerHash);
                    result.put("headers", headers);
                }
                return result;
            }
            return null;
        }
    }
}

