/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.log;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.Collection;
import java.util.Collections;

public class PathTagSanitizer
implements EventMapper<Fact, Fact> {
    public static final String SANITIZED_REPLACEMENT = "X";
    private String pathTagName;

    public PathTagSanitizer(String pathTagName) {
        this.pathTagName = pathTagName;
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact = event.getValue();
        String path = fact.getDimension(this.pathTagName);
        if (path != null) {
            fact.setDimension(this.pathTagName, PathTagSanitizer.sanitize(path));
        }
        return Collections.singleton(event);
    }

    static String sanitize(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder result = new StringBuilder(path.length());
        StringBuilder part = new StringBuilder();
        boolean nonDynamic = true;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if ('/' == c) {
                if (part.length() > 0) {
                    if (nonDynamic) {
                        result.append((CharSequence)part);
                    } else {
                        result.append(SANITIZED_REPLACEMENT);
                    }
                    part.setLength(0);
                    nonDynamic = true;
                }
                result.append(c);
                continue;
            }
            part.append(c);
            if (Character.isLetter(c) || c == '-' || c == '_') continue;
            nonDynamic = false;
        }
        if (part.length() > 0) {
            if (nonDynamic) {
                result.append((CharSequence)part);
            } else {
                result.append(SANITIZED_REPLACEMENT);
            }
        }
        return result.toString();
    }
}

