/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.ScheduledLimiterAndAggregator;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;

public class LongAverageCalculator
implements EventMapper<Fact, Fact> {
    String inputBaseMetric;
    String outputAverageMetric;

    public LongAverageCalculator(String inputBaseMetric, String outputAverageMetric) {
        this.inputBaseMetric = inputBaseMetric;
        this.outputAverageMetric = outputAverageMetric;
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact = event.getValue();
        Long count = fact.getLongMetric(ScheduledLimiterAndAggregator.toCountMetric(this.inputBaseMetric));
        Long sum = fact.getLongMetric(ScheduledLimiterAndAggregator.toSumMetric(this.inputBaseMetric));
        if ((Long)ObjectUtils.defaultIfNull((Object)count, (Object)0L) != 0L && sum != null) {
            fact.setLongMetric(this.outputAverageMetric, sum / count);
        }
        return Collections.singleton(event);
    }
}

