/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Version {
    public static final String SEMVER_PATTERN = "(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)(?:-SNAPSHOT)?";
    private final int mayor;
    private final int minor;
    private final int patch;

    private Version(int mayor, int minor, int patch) {
        this.mayor = mayor;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version create(File directory, String patternFile, String cannotDetectVersionMsg) {
        String versionStr = Version.getVersionStr(directory, patternFile, cannotDetectVersionMsg);
        String[] partsStr = versionStr.split("\\.");
        if (partsStr.length != 3) {
            throw Version.invalidVersionString(versionStr);
        }
        try {
            List parts = Arrays.stream(partsStr).map(Version::parseVersionInt).collect(Collectors.toList());
            return new Version((Integer)parts.get(0), (Integer)parts.get(1), (Integer)parts.get(2));
        }
        catch (NumberFormatException e) {
            throw Version.invalidVersionString(versionStr);
        }
    }

    private static String getVersionStr(File directory, String patternFile, String cannotDetectVersionMsg) {
        File file = (File)Arrays.stream((Object[])Objects.requireNonNull(directory.listFiles((dir, name) -> name.matches(patternFile)))).findFirst().orElseThrow(() -> new IllegalArgumentException(cannotDetectVersionMsg));
        if (file.isFile()) {
            Pattern pattern = Pattern.compile(SEMVER_PATTERN, 8);
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.find()) {
                throw new IllegalArgumentException(cannotDetectVersionMsg);
            }
            return matcher.group();
        }
        throw new IllegalArgumentException(cannotDetectVersionMsg);
    }

    private static IllegalArgumentException invalidVersionString(String versionStr) {
        return new IllegalArgumentException(String.format("Invalid version string '%s'", versionStr));
    }

    public int getMayor() {
        return this.mayor;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    private static int parseVersionInt(String s) {
        return Integer.parseInt(s.replace("-SNAPSHOT", ""));
    }
}

