/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.CollectorAgentBase;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import com.mulesoft.analytics.collector.config.DeploymentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.AbstractDeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.application.Application;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends CollectorAgentBase
implements MuleAgentService,
DeploymentServiceAware,
Startable,
Stoppable {
    @Inject
    protected List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    @Inject
    protected AppStatsHandler appStatsHandler;
    private DeploymentService deploymentService;
    private DeploymentListener deploymentListener;
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();

    public void start() {
        if (this.deploymentService == null) {
            LOGGER.error("DeploymentService not set");
            return;
        }
        this.startCollector(3);
        if (this.deploymentListener == null) {
            this.deploymentListener = new DeploymentListener();
        }
        this.deploymentService.addDeploymentListener((org.mule.module.launcher.DeploymentListener)this.deploymentListener);
    }

    @Override
    protected void onCollectorStart() {
        this.registerListenersForAllApps();
    }

    public void stop() {
        this.stopCollector();
    }

    @Override
    protected void onCollectorStop() {
        this.unregisterListenersForAllApps();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    private void registerListeners(String appId, MuleContext appMuleContext) {
        if (appMuleContext != null) {
            try {
                LOGGER.info("Registering listeners for application {}", (Object)appId);
                appId = this.configuration.overrideAppId(appId);
                ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.pipelineRegistry, appId);
                this.connectorListeners.put(appId, connectorListener);
                appMuleContext.registerListener((ServerNotificationListener)connectorListener);
                ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.pipelineRegistry, this.logWriter, this.configuration, appId);
                this.processorListeners.put(appId, processorListener);
                appMuleContext.registerListener((ServerNotificationListener)processorListener);
                CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, appId);
                this.customListeners.put(appId, customListener);
                appMuleContext.registerListener((ServerNotificationListener)customListener);
            }
            catch (NotificationException e) {
                LOGGER.error("Could not register listeners for application {}", (Object)appId);
            }
        }
    }

    private void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                this.registerListeners(app.getArtifactName(), app.getMuleContext());
                this.loadAppSpecificProperties(app.getArtifactName(), app.getMuleContext());
            }
        }
    }

    private void unregisterListenersForAllApps() {
        LOGGER.info("Stopping");
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                CustomNotificationListener customListener;
                ConnectorNotificationListener connectorListener;
                String appName = app.getArtifactName();
                MuleContext appMuleContext = app.getMuleContext();
                LOGGER.info("Un-registering listeners for application {}", (Object)appName);
                ProcessorNotificationListener processorListener = this.processorListeners.remove(appName);
                if (processorListener != null) {
                    appMuleContext.unregisterListener((ServerNotificationListener)processorListener);
                }
                if ((connectorListener = this.connectorListeners.remove(appName)) != null) {
                    appMuleContext.unregisterListener((ServerNotificationListener)connectorListener);
                }
                if ((customListener = this.customListeners.remove(appName)) == null) continue;
                appMuleContext.unregisterListener((ServerNotificationListener)customListener);
            }
            if (this.deploymentListener != null) {
                this.deploymentService.removeDeploymentListener((org.mule.module.launcher.DeploymentListener)this.deploymentListener);
                this.deploymentListener = null;
            }
        }
    }

    private void loadAppSpecificProperties(String appId, MuleContext appMuleContext) {
        if (appMuleContext != null) {
            if (this.agentApplicationPropertiesService != null) {
                this.configuration.addAppSpecificProperties(appId, this.agentApplicationPropertiesService.getPropertiesForApplication(appId));
            }
            Properties props = new Properties();
            for (Map.Entry entry : appMuleContext.getRegistry().lookupByType(String.class).entrySet()) {
                if (!((String)entry.getKey()).startsWith("anypoint.platform.visualizer.")) continue;
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.configuration.addAppSpecificProperties(appId, props);
        }
    }

    private class DeploymentListener
    extends AbstractDeploymentListener {
        private DeploymentListener() {
        }

        public void onDeploymentSuccess(String appName) {
            CollectorAgentService.this.completeDelayedInitialization();
            if (CollectorAgentService.this.configuration.isRunning()) {
                Application app;
                if (CollectorAgentService.this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
                    CollectorAgentService.this.filebeatConfig.generateAppLogConfigFile(appName);
                }
                if ((app = CollectorAgentService.this.deploymentService.findApplication(appName)) != null) {
                    MuleContext context = app.getMuleContext();
                    CollectorAgentService.this.registerListeners(appName, context);
                    CollectorAgentService.this.loadAppSpecificProperties(appName, context);
                } else {
                    CollectorAgentBase.LOGGER.error("Application not found: " + appName);
                }
            }
        }

        public void onUndeploymentSuccess(String appName) {
            if (CollectorAgentService.this.configuration.isRunning()) {
                CollectorAgentService.this.pipelineRegistry.unregister(appName);
                CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
                CollectorAgentService.this.customMetricHandler.unregister(appName);
                if (CollectorAgentService.this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
                    CollectorAgentService.this.filebeatConfig.deleteAppLogConfigFile(appName);
                }
                if (CollectorAgentService.this.agentApplicationPropertiesService != null) {
                    CollectorAgentService.this.configuration.removeAppSpecificProperties(appName);
                }
            }
        }
    }
}

