/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.mulesoft.analytics.collector.agent.InvocationContext;
import com.mulesoft.analytics.collector.agent.InvocationContextToFactTransformer;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.EnvironmentProvider;
import com.mulesoft.analytics.collector.log.FactLogger;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import com.mulesoft.analytics.collector.log.PathTagSanitizer;
import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactCombiner;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import com.mulesoft.analytics.collector.pipeline.LongAverageCalculator;
import com.mulesoft.analytics.collector.pipeline.LongMetricDuplicator;
import com.mulesoft.analytics.collector.pipeline.ScheduledLimiterAndAggregator;
import com.mulesoft.analytics.collector.pipeline.SynchronizedStep;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PipelineRegistry {
    @Inject
    private Configuration configuration;
    @Inject
    private MetricLogWriter logWriter;
    private Map<String, Map<FactMeta, EventPipeline<InvocationContext>>> commonPipelineMap = new HashMap<String, Map<FactMeta, EventPipeline<InvocationContext>>>();

    public synchronized <T> EventPipeline<T> createPipeline(String appId, FactMeta factMeta, EventMapper<T, InvocationContext> notificationMapper) {
        EventPipeline pipeline = EventPipeline.startWith(new AsyncProcessor(this.configuration.getPrebufferMaxSize())).continueWith(notificationMapper).endWith(this.getCommonPipeline(appId, factMeta, new FactLogger(this.logWriter)));
        pipeline.start();
        return pipeline;
    }

    EventPipeline<InvocationContext> getCommonPipeline(String appId, FactMeta factMeta, EventConsumer<Fact> eventConsumer) {
        EventPipeline<InvocationContext> pipeline;
        Map<FactMeta, EventPipeline<InvocationContext>> innerMap = this.commonPipelineMap.get(appId);
        if (innerMap == null) {
            innerMap = new HashMap<FactMeta, EventPipeline<InvocationContext>>();
            this.commonPipelineMap.put(appId, innerMap);
        }
        if ((pipeline = innerMap.get(factMeta)) == null) {
            pipeline = EventPipeline.startWith(new SynchronizedStep()).continueWith(new InvocationContextToFactTransformer(factMeta.getName())).continueWith(new FactCombiner(this.configuration.getCombinerMaxSize(), "response_type", "response_time")).continueWith(new PathTagSanitizer("endpoint")).continueWith(new ScheduledLimiterAndAggregator((long)this.configuration.getAggregationTimeInterval(), factMeta, 1).setSamplingSize(5).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).continueWith(new LongAverageCalculator("response_time", "avg_response_time")).continueWith(new LongMetricDuplicator("response_time.count", "avg_request_count")).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(eventConsumer);
            pipeline.start();
            innerMap.put(factMeta, pipeline);
        }
        return pipeline;
    }

    public EventPipeline<Fact> createCustomMetricPipeline(String appId, String metricName, FactMeta metricMeta) {
        EventPipeline<Fact> pipeline = EventPipeline.startWith(new AsyncProcessor(this.configuration.getPrebufferMaxSize())).continueWith(new ScheduledLimiterAndAggregator((long)this.configuration.getAggregationTimeInterval(), metricMeta, this.configuration.getAggregationTopN()).setOtherValue(this.configuration.getOtherValue())).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(new FactLogger(this.logWriter));
        pipeline.start();
        return pipeline;
    }

    public synchronized void unregister(String appId) {
        Map<FactMeta, EventPipeline<InvocationContext>> commonPipelines = this.commonPipelineMap.remove(appId);
        if (commonPipelines != null) {
            for (EventPipeline<InvocationContext> p : commonPipelines.values()) {
                p.stop();
            }
        }
    }
}

