/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.data;

import com.mulesoft.analytics.limiter.EventAggregate;
import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.UserEvent;
import java.util.List;

public class AggregatedResult
implements EventLimiterResult {
    private boolean isLimited;
    private List<? extends EventAggregate> events;
    private NamePath[] retainedDims;

    public AggregatedResult(boolean isLimited, List<? extends EventAggregate> events, NamePath[] retainedDims) {
        this.isLimited = isLimited;
        this.events = events;
        this.retainedDims = retainedDims;
    }

    @Override
    public boolean isLimited() {
        return this.isLimited;
    }

    @Override
    public boolean isAggregated() {
        return true;
    }

    @Override
    public UserEvent[] getEventsNotAggregated() {
        return null;
    }

    @Override
    public EventAggregate[] getEventAggregates() {
        return this.events.toArray(new EventAggregate[this.events.size()]);
    }

    @Override
    public Object[] getRetainingValues() {
        if (!this.events.isEmpty() && this.retainedDims.length > 0) {
            return this.events.get(0).getSampleEvent().getDimensionValues(this.retainedDims);
        }
        return null;
    }

    @Override
    public UserEvent getSampleEvent() {
        if (!this.events.isEmpty()) {
            return this.events.get(0).getSampleEvent();
        }
        return null;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("{isLimited = " + this.isLimited() + ", isAggregated = " + this.isAggregated() + ", aggr events = [");
        for (EventAggregate eventAggregate : this.events) {
            out.append("\n    ").append(eventAggregate.toString());
        }
        out.append("\n]}");
        return out.toString();
    }
}

