/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;

abstract class AbstractListener {
    AbstractListener() {
    }

    static String getComponentName(Component component) {
        ComponentIdentifier componentIdentifier = AbstractListener.getComponentIdentifier(component);
        if (componentIdentifier != null) {
            return componentIdentifier.getNamespace();
        }
        return null;
    }

    static String getComponentOperation(Component component) {
        ComponentIdentifier componentIdentifier = AbstractListener.getComponentIdentifier(component);
        if (componentIdentifier != null) {
            return componentIdentifier.getName();
        }
        return null;
    }

    static <T> T invokeViaReflection(Object obj, String methodName, Class<T> returnType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = obj.getClass().getMethod(methodName, null);
        Object result = m.invoke(obj, (Object[])null);
        return returnType.cast(result);
    }

    static String getInvocationId(Event event, Component component) {
        String id = event.getContext().getId();
        if (id.length() > 38) {
            id = id.substring(0, 38);
        }
        return id + AbstractListener.getComponentLocationStringOrEmpty(component);
    }

    private static ComponentIdentifier getComponentIdentifier(Component component) {
        TypedComponentIdentifier typedComponentIdentifier;
        ComponentLocation componentLocation;
        if (component != null && (componentLocation = component.getLocation()) != null && (typedComponentIdentifier = componentLocation.getComponentIdentifier()) != null) {
            return typedComponentIdentifier.getIdentifier();
        }
        return null;
    }

    private static String getComponentLocationStringOrEmpty(Component component) {
        ComponentLocation componentLocation;
        if (component != null && (componentLocation = component.getLocation()) != null) {
            return componentLocation.getLocation();
        }
        return "";
    }
}

