/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CustomMetricHandler {
    public static final int CUSTOM_METRIC_NOTIFICATION_ID = 703591261;
    public static final String KEY_METRIC_NAME = "metric_name";
    public static final String KEY_DIMENSIONS = "dimensions";
    public static final String KEY_FACTS = "facts";
    public static final String KEY_DIM_VALUE = "value";
    public static final String KEY_DIM_COLLAPSIBLE = "collapsible";
    @Inject
    private PipelineRegistry pipelineRegistry;
    private Map<String, Map<String, FactMeta>> factMetaCache = new HashMap<String, Map<String, FactMeta>>();
    private Map<String, Map<String, EventPipeline<Fact>>> pipelineCache = new HashMap<String, Map<String, EventPipeline<Fact>>>();

    static String getMetricName(Map<?, ?> metric) {
        Object obj = metric.get(KEY_METRIC_NAME);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    static void addDimensions(FactMeta.Builder builder, Map<?, ?> metric) {
        Object obj = metric.get(KEY_DIMENSIONS);
        if (obj instanceof Map) {
            Map dimensions = (Map)obj;
            for (Map.Entry e : dimensions.entrySet()) {
                if (!(e.getKey() instanceof String) || !(e.getValue() instanceof Map)) continue;
                String dimensionName = (String)e.getKey();
                Map dim = (Map)e.getValue();
                obj = dim.get(KEY_DIM_COLLAPSIBLE);
                if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                    builder.addRetainingDimension(dimensionName);
                    continue;
                }
                builder.addCollapsibleDimension(dimensionName);
            }
        }
    }

    static void addFacts(FactMeta.Builder builder, Map<?, ?> metric) {
        Object obj = metric.get(KEY_FACTS);
        if (obj instanceof Map) {
            Map facts = (Map)obj;
            for (Map.Entry e : facts.entrySet()) {
                if (!(e.getKey() instanceof String) || !(e.getValue() instanceof Number)) continue;
                String factName = (String)e.getKey();
                builder.addDoubleMetric(factName);
            }
        }
    }

    private synchronized FactMeta resolveFactMeta(Map<?, ?> metric, String appId) {
        String metricName;
        FactMeta factMeta;
        Map<String, FactMeta> appMap = this.factMetaCache.get(appId);
        if (appMap == null) {
            appMap = new HashMap<String, FactMeta>();
            this.factMetaCache.put(appId, appMap);
        }
        if ((factMeta = appMap.get(metricName = CustomMetricHandler.getMetricName(metric))) == null) {
            FactMeta.Builder builder = new FactMeta.Builder("custom_metric");
            builder.addCollapsibleDimension(KEY_METRIC_NAME);
            CustomMetricHandler.addDimensions(builder, metric);
            CustomMetricHandler.addFacts(builder, metric);
            factMeta = builder.build();
            appMap.put(metricName, factMeta);
            this.factMetaCache.put(appId, appMap);
        }
        return factMeta;
    }

    static void setDimensions(Fact fact, Collection<String> names, Map<?, ?> values) {
        for (String name : names) {
            Object obj = values.get(name);
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            obj = map.get(KEY_DIM_VALUE);
            fact.setDimension(name, String.valueOf(obj));
        }
    }

    static boolean setFacts(Fact fact, Collection<String> names, Map<?, ?> values) {
        for (String name : names) {
            Object value = values.get(name);
            if (value instanceof Integer) {
                fact.setDoubleMetric(name, (double)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                fact.setDoubleMetric(name, (double)((Long)value));
                continue;
            }
            if (value instanceof Float) {
                fact.setDoubleMetric(name, Double.valueOf(((Float)value).floatValue()));
                continue;
            }
            if (value instanceof Double) {
                fact.setDoubleMetric(name, (Double)value);
                continue;
            }
            return false;
        }
        return true;
    }

    Fact createMetricFact(Map<?, ?> metric, String appId) {
        FactMeta metricMeta = this.resolveFactMeta(metric, appId);
        Fact fact = new Fact("custom_metric");
        String metricName = CustomMetricHandler.getMetricName(metric);
        fact.setDimension(KEY_METRIC_NAME, metricName);
        fact.setDimension("app_id", appId);
        Object obj = metric.get(KEY_DIMENSIONS);
        if (obj instanceof Map) {
            Map dimValues = (Map)obj;
            CustomMetricHandler.setDimensions(fact, metricMeta.getCollapsibleDimensions(), dimValues);
            CustomMetricHandler.setDimensions(fact, metricMeta.getRetainingDimensions(), dimValues);
        }
        if ((obj = metric.get(KEY_FACTS)) instanceof Map) {
            Map factValues = (Map)obj;
            if (!CustomMetricHandler.setFacts(fact, metricMeta.getLongMetrics(), factValues) || !CustomMetricHandler.setFacts(fact, metricMeta.getDoubleMetrics(), factValues)) {
                return null;
            }
        }
        return fact;
    }

    private synchronized EventPipeline<Fact> getPipeline(String appId, String metricName, FactMeta metricMeta) {
        EventPipeline<Fact> pipeline;
        Map<String, EventPipeline<Fact>> appMap = this.pipelineCache.get(appId);
        if (appMap == null) {
            appMap = new HashMap<String, EventPipeline<Fact>>();
            this.pipelineCache.put(appId, appMap);
        }
        if ((pipeline = appMap.get(metricName)) == null) {
            pipeline = this.pipelineRegistry.createCustomMetricPipeline(appId, metricMeta);
            appMap.put(metricName, pipeline);
        }
        return pipeline;
    }

    public boolean logMetric(Object untypedMetric, String appId) {
        if (untypedMetric instanceof Map) {
            Fact fact;
            EventPipeline<Fact> pipeline;
            Map metric = (Map)untypedMetric;
            String metricName = CustomMetricHandler.getMetricName(metric);
            FactMeta metricMeta = this.resolveFactMeta(metric, appId);
            if (metricName != null && metricMeta != null && (pipeline = this.getPipeline(appId, metricName, metricMeta)) != null && (fact = this.createMetricFact(metric, appId)) != null) {
                pipeline.submit(new Event<Fact>(fact));
                return true;
            }
        }
        return false;
    }

    public synchronized void unregister(String appId) {
        this.factMetaCache.remove(appId);
        Map<String, EventPipeline<Fact>> customMetricPipelines = this.pipelineCache.remove(appId);
        if (customMetricPipelines != null) {
            for (EventPipeline<Fact> p : customMetricPipelines.values()) {
                p.stop();
            }
        }
    }
}

