/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.data.StringNamePath;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;

public class EventProcessorConfigImpl
implements EventProcessorConfig {
    public static final String LIMITER_STRATEGY_NAME = "limiter.strategy.name";
    public static final String LIMITER_STRATEGY_SAMPLING_SIZE = "limiter.strategy.sampling-size";
    public static final String LIMITER_STRATEGY_CONTAINER_SIZE = "limiter.strategy.container-size";
    public static final String LIMITER_OUTPUT_MAXIMUM = "limiter.output.size";
    public static final String LIMITER_STRATEGY_DISTRIBUTION_BOUND = "limiter.output.distribution-bound";
    public static final String LIMITER_INPUT_COLLASPSEABLE_DIMENSIONS = "limiter.input.collaspeble-dimensions";
    public static final String LIMITER_INPUT_RETAINING_DIMENSIONS = "limiter.input.retaining-dimensions";
    public static final String LIMITER_INPUT_LONG_METRIC_DIMENSIONS = "limiter.input.long-metric-dimensions";
    public static final String LIMITER_INPUT_DOUBLE_METRIC_DIMENSIONS = "limiter.input.double-metric-dimensions";
    private static final int DEFAULT_MAX_OUTPUT = 100;
    private StrategyType strategy;
    private int maxOutput = 100;
    private int containerSize = 1000;
    private int samplingSize = 10;
    private double distributionBound = 0.8;
    private Set<NamePath> collapsibleDimensions;
    private Set<NamePath> retainingDimensions;
    private Set<NamePath> longMetricDimensions;
    private Set<NamePath> doubleMetricDimensions;

    public void setProperties(Properties properties) {
        this.setConfiguration(ConfigurationConverter.getConfiguration((Properties)properties));
    }

    public void setConfiguration(Configuration config) {
        String strategyName = config.getString(LIMITER_STRATEGY_NAME);
        if (strategyName != null) {
            StrategyType s = StrategyType.fromName(strategyName);
            if (s == null) {
                throw new IllegalArgumentException(strategyName + " is not a valid strategy.");
            }
            this.strategy = s;
        }
        this.maxOutput = config.getInt(LIMITER_OUTPUT_MAXIMUM, this.maxOutput);
        this.samplingSize = config.getInt(LIMITER_STRATEGY_SAMPLING_SIZE, this.samplingSize);
        this.containerSize = config.getInt(LIMITER_STRATEGY_CONTAINER_SIZE, this.containerSize);
        this.distributionBound = config.getDouble(LIMITER_STRATEGY_DISTRIBUTION_BOUND, this.distributionBound);
        NamePath[] pathArray = this.toNamePaths(config, LIMITER_INPUT_COLLASPSEABLE_DIMENSIONS);
        this.collapsibleDimensions = new HashSet<NamePath>();
        this.collapsibleDimensions.addAll(Arrays.asList(pathArray));
        pathArray = this.toNamePaths(config, LIMITER_INPUT_RETAINING_DIMENSIONS);
        this.retainingDimensions = new HashSet<NamePath>();
        this.retainingDimensions.addAll(Arrays.asList(pathArray));
        pathArray = this.toNamePaths(config, LIMITER_INPUT_LONG_METRIC_DIMENSIONS);
        this.longMetricDimensions = new HashSet<NamePath>();
        this.longMetricDimensions.addAll(Arrays.asList(pathArray));
        pathArray = this.toNamePaths(config, LIMITER_INPUT_DOUBLE_METRIC_DIMENSIONS);
        this.doubleMetricDimensions = new HashSet<NamePath>();
        this.doubleMetricDimensions.addAll(Arrays.asList(pathArray));
    }

    public Properties toProperties() {
        return ConfigurationConverter.getProperties((Configuration)this.toConfiguration());
    }

    public Configuration toConfiguration() {
        throw new UnsupportedOperationException("This operation is not supported right now.");
    }

    private NamePath[] toNamePaths(Configuration config, String propertyName) {
        String[] flatNamePaths = config.getStringArray(propertyName);
        if (flatNamePaths == null) {
            return new NamePath[0];
        }
        NamePath[] result = new NamePath[flatNamePaths.length];
        for (int i = 0; i < flatNamePaths.length; ++i) {
            result[i] = flatNamePaths[i] == null ? null : new StringNamePath(flatNamePaths[i]);
        }
        return result;
    }

    @Override
    public StrategyType getStrategy() {
        return this.strategy;
    }

    public void setStrategy(StrategyType strategy) {
        this.strategy = strategy;
    }

    @Override
    public int getMaxOutput() {
        return this.maxOutput;
    }

    public void setMaxOutput(int maxOutput) {
        if (maxOutput < 0) {
            throw new IllegalArgumentException("Can only have a non-negative maxOutputSize");
        }
        this.maxOutput = maxOutput;
    }

    @Override
    public int getSamplingSize() {
        return this.samplingSize;
    }

    public void setSamplingSize(int samplingSize) {
        if (samplingSize < 0) {
            throw new IllegalArgumentException("Can only have a non-negative samplingSize");
        }
        this.samplingSize = samplingSize;
    }

    @Override
    public int getContainerSize() {
        return this.containerSize;
    }

    public void setContainerSize(int containerSize) {
        if (containerSize <= 0) {
            throw new IllegalArgumentException("Can only have a positive containerSize");
        }
        this.containerSize = containerSize;
    }

    @Override
    public double getDistributionBound() {
        return this.distributionBound;
    }

    public void setDistributionBound(double distributionBound) {
        this.distributionBound = distributionBound;
    }

    public Set<NamePath> getCollapsibleDimensions() {
        return this.collapsibleDimensions;
    }

    public void setCollapsibleDimensions(Set<NamePath> collapsibleDimensions) {
        this.collapsibleDimensions = collapsibleDimensions;
    }

    public Set<NamePath> getRetainingDimensions() {
        return this.retainingDimensions;
    }

    public void setRetainingDimensions(Set<NamePath> retainingDimensions) {
        this.retainingDimensions = retainingDimensions;
    }

    public Set<NamePath> getLongMetricDimensions() {
        return this.longMetricDimensions;
    }

    public void setLongMetricDimensions(Set<NamePath> metricDimensions) {
        this.longMetricDimensions = metricDimensions;
    }

    public Set<NamePath> getDoubleMetricDimensions() {
        return this.doubleMetricDimensions;
    }

    public void setDoubleMetricDimensions(Set<NamePath> metricDimensions) {
        this.doubleMetricDimensions = metricDimensions;
    }

    @Override
    public NamePath[] getCollapsibleDims() {
        return this.getSortedArray(this.collapsibleDimensions);
    }

    @Override
    public NamePath[] getRetainingDims() {
        return this.getSortedArray(this.retainingDimensions);
    }

    @Override
    public NamePath[] getLongMetricDims() {
        return this.getSortedArray(this.getLongMetricDimensions());
    }

    @Override
    public NamePath[] getDoubleMetricDims() {
        return this.getSortedArray(this.getDoubleMetricDimensions());
    }

    private NamePath[] getSortedArray(Set<NamePath> namePaths) {
        if (namePaths != null) {
            NamePath[] result = namePaths.toArray(new NamePath[namePaths.size()]);
            Arrays.sort(result, StringNamePath.CASE_INSENSITIVE_NAME_PATH_COMPARATOR);
            return result;
        }
        return new NamePath[0];
    }

    public String toString() {
        return "EventProcessorConfig [\n  strategy=" + (Object)((Object)this.strategy) + ", \n  maxOutput=" + this.maxOutput + ", \n  samplingSize=" + this.samplingSize + ", \n  containerSize=" + this.containerSize + ", \n  collapsibleDimensions=" + Arrays.toString(this.getCollapsibleDims()) + ", \n  retainingDimensions=" + Arrays.toString(this.getRetainingDims()) + ", \n  longMetricDimensions=" + Arrays.toString(this.getLongMetricDims()) + ", \n  doubleMetricDimensions=" + Arrays.toString(this.getDoubleMetricDims()) + "]";
    }
}

