/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.policy;

import com.google.common.base.Preconditions;
import com.mulesoft.analytics.collector.policy.PolicyTemplate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class PolicyTemplateFactory {
    private static final String POLICY_TEMPLATES_FOLDER = "policy-templates";
    private static final String TEMPLATE_FILE_NAME = "template.xml";
    private static final String POLICY_TEMPLATE_NAME = "analytics-metric-collector-policy-template";
    private static final String POLICY_TEMPLATE_JAR_NAME = "/analytics-metric-collector-mule-policy.jar";
    private static PolicyTemplate policyTemplate;

    public static synchronized PolicyTemplate getPolicyTemplate() throws IOException {
        if (policyTemplate == null || !policyTemplate.getTemplateDescriptor().getRootFolder().exists()) {
            File templatesTempFolder = new File(MuleFoldersUtil.getExecutionFolder(), POLICY_TEMPLATES_FOLDER);
            File templateExplodedFolder = new File(templatesTempFolder, POLICY_TEMPLATE_NAME);
            File resource = PolicyTemplateFactory.getFileAsResource(POLICY_TEMPLATE_JAR_NAME, templatesTempFolder);
            org.mule.runtime.core.api.util.FileUtils.unzip((File)resource, (File)templateExplodedFolder);
            PolicyTemplateDescriptor policyTemplateDescriptor = new PolicyTemplateDescriptor(POLICY_TEMPLATE_NAME);
            BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setGroupId("com.mulesoft.analytics").setArtifactId(POLICY_TEMPLATE_NAME).setVersion("1.0.0").setClassifier("mule-policy").build();
            policyTemplateDescriptor.setBundleDescriptor(bundleDescriptor);
            policyTemplateDescriptor.setRootFolder(templateExplodedFolder);
            File templateFile = new File(templateExplodedFolder, TEMPLATE_FILE_NAME);
            policyTemplate = new PolicyTemplate(templateFile, policyTemplateDescriptor);
        }
        return policyTemplate;
    }

    private static File getFileAsResource(String resource, File targetFolder) throws IOException {
        InputStream resourceStream = PolicyTemplateFactory.class.getResourceAsStream(resource);
        Preconditions.checkState((resourceStream != null ? 1 : 0) != 0, (Object)String.format("Could not find policy template asset %s for %s", resource, POLICY_TEMPLATE_NAME));
        File targetFile = new File(targetFolder, resource);
        FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
        return targetFile;
    }
}

