/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import com.mulesoft.analytics.limiter.EventProcessor;
import com.mulesoft.analytics.limiter.EventProcessorConfigImpl;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.processor.EventProcessorImpl;
import com.mulesoft.analytics.limiter.processor.ImmutableEventProcessorConfig;
import com.mulesoft.analytics.limiter.processor.ImmutableEventProcessorFactory;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;

public class DefaultEventProcessorBuilder {
    private EventProcessorConfigImpl config = new EventProcessorConfigImpl();
    private HashSet<NamePath> retainingDims = new HashSet();
    private HashSet<NamePath> collapsibleDims = new HashSet();
    private HashSet<NamePath> longMetricDims = new HashSet();
    private HashSet<NamePath> doubleMetricDims = new HashSet();

    public DefaultEventProcessorBuilder setProperties(Properties properties) {
        this.config.setProperties(properties);
        return this;
    }

    public DefaultEventProcessorBuilder addCollapsibleDimension(NamePath ... namePaths) {
        for (NamePath namePath : namePaths) {
            this.collapsibleDims.add(namePath);
        }
        return this;
    }

    public DefaultEventProcessorBuilder addRetainingDimension(NamePath ... namePaths) {
        for (NamePath namePath : namePaths) {
            this.retainingDims.add(namePath);
        }
        return this;
    }

    public DefaultEventProcessorBuilder addLongMetric(NamePath ... namePaths) {
        for (NamePath namePath : namePaths) {
            this.longMetricDims.add(namePath);
        }
        return this;
    }

    public DefaultEventProcessorBuilder addDoubleMetric(NamePath ... namePaths) {
        for (NamePath namePath : namePaths) {
            this.doubleMetricDims.add(namePath);
        }
        return this;
    }

    public DefaultEventProcessorBuilder setConfiguration(Configuration config) {
        this.config.setConfiguration(config);
        return this;
    }

    public DefaultEventProcessorBuilder setStrategy(StrategyType strategy) {
        this.config.setStrategy(strategy);
        return this;
    }

    public DefaultEventProcessorBuilder setMaxOutput(int maxOutput) {
        this.config.setMaxOutput(maxOutput);
        return this;
    }

    public DefaultEventProcessorBuilder setSamplingSize(int samplingSize) {
        this.config.setSamplingSize(samplingSize);
        return this;
    }

    public DefaultEventProcessorBuilder setContainerSize(int containerSize) {
        this.config.setContainerSize(containerSize);
        return this;
    }

    public DefaultEventProcessorBuilder setDistributionBound(double distributionBound) {
        this.config.setDistributionBound(distributionBound);
        return this;
    }

    public DefaultEventProcessorBuilder setCollaspeableDimensions(Set<NamePath> collaspeableDimensions) {
        this.config.setCollapsibleDimensions(collaspeableDimensions);
        return this;
    }

    public DefaultEventProcessorBuilder setRetainingDimensions(Set<NamePath> retainingDimensions) {
        this.config.setRetainingDimensions(retainingDimensions);
        return this;
    }

    public DefaultEventProcessorBuilder setLongMetricDimensions(Set<NamePath> metricDimensions) {
        this.config.setLongMetricDimensions(metricDimensions);
        return this;
    }

    public DefaultEventProcessorBuilder setDoubleMetricDimensions(Set<NamePath> metricDimensions) {
        this.config.setDoubleMetricDimensions(metricDimensions);
        return this;
    }

    public EventProcessor build() {
        this.configure();
        return new EventProcessorImpl(this.config);
    }

    public EventProcessor.Factory buildFactory() {
        this.configure();
        ImmutableEventProcessorConfig immutableConfig = new ImmutableEventProcessorConfig(this.config.getMaxOutput(), this.config.getSamplingSize(), this.config.getContainerSize(), this.config.getDistributionBound(), this.config.getStrategy(), this.config.getRetainingDims(), this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
        return new ImmutableEventProcessorFactory(immutableConfig);
    }

    private void configure() {
        if (this.config.getMaxOutput() <= 0) {
            throw new IllegalArgumentException("Must set the output size to be > 0");
        }
        if (this.config.getStrategy() == null) {
            throw new IllegalArgumentException("Must specify a limiter strategy.");
        }
        if (this.config.getContainerSize() == 0 || this.config.getContainerSize() < this.config.getMaxOutput()) {
            throw new IllegalArgumentException("Sampling size (" + this.config.getContainerSize() + ") must be > output size (" + this.config.getMaxOutput() + ")");
        }
        if (this.config.getCollapsibleDimensions() != null && !this.config.getCollapsibleDimensions().isEmpty()) {
            for (NamePath p : this.config.getCollapsibleDimensions()) {
                this.collapsibleDims.add(p);
            }
        }
        if (this.config.getRetainingDimensions() != null && !this.config.getRetainingDimensions().isEmpty()) {
            for (NamePath p : this.config.getRetainingDimensions()) {
                this.retainingDims.add(p);
            }
        }
        if (this.config.getLongMetricDimensions() != null && !this.config.getLongMetricDimensions().isEmpty()) {
            for (NamePath p : this.config.getLongMetricDimensions()) {
                this.longMetricDims.add(p);
            }
        }
        if (this.config.getDoubleMetricDimensions() != null && !this.config.getDoubleMetricDimensions().isEmpty()) {
            for (NamePath p : this.config.getDoubleMetricDimensions()) {
                this.doubleMetricDims.add(p);
            }
        }
        this.config.setCollapsibleDimensions(this.collapsibleDims);
        this.config.setRetainingDimensions(this.retainingDims);
        this.config.setLongMetricDimensions(this.longMetricDims);
        this.config.setDoubleMetricDimensions(this.doubleMetricDims);
    }
}

